/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.navigation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.IModelLinker;
import org.eclipse.papyrus.infra.gmfdiag.navigation.INavigationRule;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.papyrus.uml.diagram.navigation.UMLRuleHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehavioredClassifierRule
implements INavigationRule {
    public boolean handle(EObject element) {
        return element instanceof BehavioredClassifier && !(element instanceof Behavior);
    }

    public List<NavigableElement> getNextPossibleElements(NavigableElement currentNavElement) {
        LinkedList<NavigableElement> nextPossibleElements = new LinkedList<NavigableElement>();
        EReference classifierBehaviorFeature = UMLPackage.Literals.BEHAVIORED_CLASSIFIER__CLASSIFIER_BEHAVIOR;
        final BehavioredClassifier behavioredClassifier = (BehavioredClassifier)currentNavElement.getElement();
        Behavior classifierBehavior = behavioredClassifier.getClassifierBehavior();
        if (classifierBehavior != null) {
            nextPossibleElements.add((NavigableElement)new ExistingNavigableElement((EObject)classifierBehavior, (EStructuralFeature)classifierBehaviorFeature));
        }
        UMLRuleHelper.addBehaviorCreatedNavigableElements(nextPossibleElements, currentNavElement, (EStructuralFeature)classifierBehaviorFeature, new IModelLinker(){

            public void linkToModel(EObject toLink) {
                Behavior existing = behavioredClassifier.getClassifierBehavior();
                boolean setCB = true;
                if (existing != null) {
                    setCB = MessageDialog.openQuestion((Shell)new Shell(), (String)"Overwrite classifier behavior", (String)("The classifier <" + behavioredClassifier.getName() + "> already has a classifier behavior (" + existing.getName() + "). Do you want to overwrite it with the behavior of the new diagram?"));
                }
                if (setCB) {
                    behavioredClassifier.setClassifierBehavior((Behavior)toLink);
                } else {
                    behavioredClassifier.getOwnedBehaviors().add((Object)((Behavior)toLink));
                }
            }
        });
        EReference ownedBehaviorFeature = UMLPackage.Literals.BEHAVIORED_CLASSIFIER__OWNED_BEHAVIOR;
        for (Behavior ownedBehavior : behavioredClassifier.getOwnedBehaviors()) {
            if (ownedBehavior == null || ownedBehavior.equals(classifierBehavior)) continue;
            nextPossibleElements.add((NavigableElement)new ExistingNavigableElement((EObject)ownedBehavior, (EStructuralFeature)ownedBehaviorFeature));
        }
        UMLRuleHelper.addBehaviorCreatedNavigableElements(nextPossibleElements, currentNavElement, (EStructuralFeature)ownedBehaviorFeature, new IModelLinker(){

            public void linkToModel(EObject toLink) {
                behavioredClassifier.getOwnedBehaviors().add((Object)((Behavior)toLink));
            }
        });
        return nextPossibleElements;
    }
}

