/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.common.helper.AssociationHelper;
import org.eclipse.papyrus.uml.diagram.profile.edit.commands.AssociationReorientCommand;
import org.eclipse.papyrus.uml.diagram.profile.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;

public class CustomAssociationReorientCommand
extends AssociationReorientCommand {
    protected EObject newEnd;
    protected EObject oldEnd;
    protected int reorientDirection;

    public CustomAssociationReorientCommand(ReorientRelationshipRequest request) {
        super(request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Type) || !(this.newEnd instanceof Type)) {
            return false;
        }
        if (this.getLink().getEndTypes().size() == 1) {
            return false;
        }
        Type target = (Type)this.getLink().getEndTypes().get(0);
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistAssociation_4001(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Type) || !(this.newEnd instanceof Type)) {
            return false;
        }
        if (this.getLink().getEndTypes().size() == 1) {
            return false;
        }
        Type source = (Type)this.getLink().getEndTypes().get(0);
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistAssociation_4001(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult reorientSource() throws ExecutionException {
        return AssociationHelper.reconnect((int)AssociationHelper.source, (Association)this.getLink(), (Type)this.getNewSource());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        return AssociationHelper.reconnect((int)AssociationHelper.target, (Association)this.getLink(), (Type)this.getNewTarget());
    }
}

