/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.part;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLDiagramUpdater;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Profile;

public class UMLDiagramContentInitializer {
    private Map myDomain2NotationMap = new HashMap();
    private Collection myLinkDescriptors = new LinkedList();

    public void initDiagramContent(Diagram diagram) {
        if (!"PapyrusUMLProfileDiagram".equals(diagram.getType())) {
            UMLDiagramEditorPlugin.getInstance().logError("Incorrect diagram passed as a parameter: " + diagram.getType());
            return;
        }
        if (!(diagram.getElement() instanceof Profile)) {
            UMLDiagramEditorPlugin.getInstance().logError("Incorrect diagram element specified: " + diagram.getElement() + " instead of Profile");
            return;
        }
        this.createProfile_1000Children((View)diagram);
        this.createLinks(diagram);
    }

    private void createProfile_1000Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getProfile_1000SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDependency_2014Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getDependency_2014OutgoingLinks(view));
    }

    private void createAssociation_2015Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getAssociation_2015OutgoingLinks(view));
    }

    private void createStereotype_1026Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getStereotype_1026OutgoingLinks(view));
        this.createStereotypeAttributeCompartment_1071Children((View)this.getCompartment(view, 1071));
        this.createStereotypeOperationCompartment_1019Children((View)this.getCompartment(view, 1019));
    }

    private void createClass_1031Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getClass_1031OutgoingLinks(view));
    }

    private void createComment_1002Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getComment_1002OutgoingLinks(view));
    }

    private void createConstraint_1014Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getConstraint_1014OutgoingLinks(view));
    }

    private void createModel_2005Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getModel_2005OutgoingLinks(view));
        this.createModelModelElementCompartment_1057Children((View)this.getCompartment(view, 1057));
    }

    private void createProfile_1030Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getProfile_1030OutgoingLinks(view));
        this.createProfileProfilePackageableElementCompartment_1042Children((View)this.getCompartment(view, 1042));
    }

    private void createPackage_2007Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getPackage_2007OutgoingLinks(view));
        this.createPackagePackageableElementCompartment_1005Children((View)this.getCompartment(view, 1005));
    }

    private void createEnumeration_2006Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getEnumeration_2006OutgoingLinks(view));
        this.createEnumerationEnumerationEnumerationLiteral_1063Children((View)this.getCompartment(view, 1063));
    }

    private void createPrimitiveType_2009Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getPrimitiveType_2009OutgoingLinks(view));
    }

    private void createDataType_2010Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getDataType_2010OutgoingLinks(view));
        this.createDataTypeDataTypeAttributeCompartment_1067Children((View)this.getCompartment(view, 1067));
        this.createDataTypeDataTypeOperationCompartment_1068Children((View)this.getCompartment(view, 1068));
    }

    private void createDiagram_2016Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getDiagram_2016OutgoingLinks(view));
    }

    private void createPrimitiveType_3026Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getPrimitiveType_3026OutgoingLinks(view));
    }

    private void createOperation_3019Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getOperation_3019OutgoingLinks(view));
    }

    private void createEnumerationLiteral_1037Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getEnumerationLiteral_1037OutgoingLinks(view));
    }

    private void createProperty_3018Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getProperty_3018OutgoingLinks(view));
    }

    private void createProperty_3002Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getProperty_3002OutgoingLinks(view));
    }

    private void createOperation_3020Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getOperation_3020OutgoingLinks(view));
    }

    private void createStereotype_1023Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getStereotype_1023OutgoingLinks(view));
        this.createStereotypeAttributeCompartment_1052Children((View)this.getCompartment(view, 1052));
        this.createStereotypeOperationCompartment_1053Children((View)this.getCompartment(view, 1053));
    }

    private void createClass_3028Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getClass_3028OutgoingLinks(view));
    }

    private void createComment_1007Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getComment_1007OutgoingLinks(view));
    }

    private void createModel_1027Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getModel_1027OutgoingLinks(view));
        this.createModelModelElementCompartment_1058Children((View)this.getCompartment(view, 1058));
    }

    private void createProfile_1024Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getProfile_1024OutgoingLinks(view));
        this.createProfileProfilePackageableElementCompartment_1051Children((View)this.getCompartment(view, 1051));
    }

    private void createPackage_1012Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getPackage_1012OutgoingLinks(view));
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getPackage_1012SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
        this.createPackagePackageableElementCompartment_11Children((View)this.getCompartment(view, 11));
    }

    private void createConstraint_1028Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getConstraint_1028OutgoingLinks(view));
    }

    private void createEnumeration_3025Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getEnumeration_3025OutgoingLinks(view));
        this.createEnumerationEnumerationEnumerationLiteral_1062Children((View)this.getCompartment(view, 1062));
    }

    private void createDataType_3027Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.getDataType_3027OutgoingLinks(view));
        this.createDataTypeDataTypeAttributeCompartment_1069Children((View)this.getCompartment(view, 1069));
        this.createDataTypeDataTypeOperationCompartment_1070Children((View)this.getCompartment(view, 1070));
    }

    private void createPackagePackageableElementCompartment_1005Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getPackagePackageableElementCompartment_1005SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createPackagePackageableElementCompartment_11Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getPackagePackageableElementCompartment_11SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createProfileProfilePackageableElementCompartment_1042Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getProfileProfilePackageableElementCompartment_1042SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createProfileProfilePackageableElementCompartment_1051Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getProfileProfilePackageableElementCompartment_1051SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createStereotypeAttributeCompartment_1071Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getStereotypeAttributeCompartment_1071SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createStereotypeAttributeCompartment_1052Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getStereotypeAttributeCompartment_1052SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createStereotypeOperationCompartment_1019Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getStereotypeOperationCompartment_1019SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createStereotypeOperationCompartment_1053Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getStereotypeOperationCompartment_1053SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createModelModelElementCompartment_1057Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getModelModelElementCompartment_1057SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createModelModelElementCompartment_1058Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getModelModelElementCompartment_1058SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createEnumerationEnumerationEnumerationLiteral_1062Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getEnumerationEnumerationEnumerationLiteral_1062SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createEnumerationEnumerationEnumerationLiteral_1063Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getEnumerationEnumerationEnumerationLiteral_1063SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDataTypeDataTypeAttributeCompartment_1067Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getDataTypeDataTypeAttributeCompartment_1067SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDataTypeDataTypeAttributeCompartment_1069Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getDataTypeDataTypeAttributeCompartment_1069SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDataTypeDataTypeOperationCompartment_1068Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getDataTypeDataTypeOperationCompartment_1068SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDataTypeDataTypeOperationCompartment_1070Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.getDataTypeDataTypeOperationCompartment_1070SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createNode(View parentView, UMLNodeDescriptor nodeDescriptor) {
        String nodeType = UMLVisualIDRegistry.getType(nodeDescriptor.getVisualID());
        Node node = ViewService.createNode((View)parentView, (EObject)nodeDescriptor.getModelElement(), (String)nodeType, (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        switch (nodeDescriptor.getVisualID()) {
            case 2014: {
                this.createDependency_2014Children((View)node);
                return;
            }
            case 2015: {
                this.createAssociation_2015Children((View)node);
                return;
            }
            case 1026: {
                this.createStereotype_1026Children((View)node);
                return;
            }
            case 1031: {
                this.createClass_1031Children((View)node);
                return;
            }
            case 1002: {
                this.createComment_1002Children((View)node);
                return;
            }
            case 1014: {
                this.createConstraint_1014Children((View)node);
                return;
            }
            case 2005: {
                this.createModel_2005Children((View)node);
                return;
            }
            case 1030: {
                this.createProfile_1030Children((View)node);
                return;
            }
            case 2007: {
                this.createPackage_2007Children((View)node);
                return;
            }
            case 2006: {
                this.createEnumeration_2006Children((View)node);
                return;
            }
            case 2009: {
                this.createPrimitiveType_2009Children((View)node);
                return;
            }
            case 2010: {
                this.createDataType_2010Children((View)node);
                return;
            }
            case 2016: {
                this.createDiagram_2016Children((View)node);
                return;
            }
            case 3026: {
                this.createPrimitiveType_3026Children((View)node);
                return;
            }
            case 3019: {
                this.createOperation_3019Children((View)node);
                return;
            }
            case 1037: {
                this.createEnumerationLiteral_1037Children((View)node);
                return;
            }
            case 3018: {
                this.createProperty_3018Children((View)node);
                return;
            }
            case 3002: {
                this.createProperty_3002Children((View)node);
                return;
            }
            case 3020: {
                this.createOperation_3020Children((View)node);
                return;
            }
            case 1023: {
                this.createStereotype_1023Children((View)node);
                return;
            }
            case 3028: {
                this.createClass_3028Children((View)node);
                return;
            }
            case 1007: {
                this.createComment_1007Children((View)node);
                return;
            }
            case 1027: {
                this.createModel_1027Children((View)node);
                return;
            }
            case 1024: {
                this.createProfile_1024Children((View)node);
                return;
            }
            case 1012: {
                this.createPackage_1012Children((View)node);
                return;
            }
            case 1028: {
                this.createConstraint_1028Children((View)node);
                return;
            }
            case 3025: {
                this.createEnumeration_3025Children((View)node);
                return;
            }
            case 3027: {
                this.createDataType_3027Children((View)node);
                return;
            }
        }
    }

    private void createLinks(Diagram diagram) {
        boolean continueLinkCreation = true;
        while (continueLinkCreation) {
            continueLinkCreation = false;
            LinkedList<UMLLinkDescriptor> additionalDescriptors = new LinkedList<UMLLinkDescriptor>();
            Iterator it = this.myLinkDescriptors.iterator();
            while (it.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = (UMLLinkDescriptor)((Object)it.next());
                if (!this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getSource()) || !this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getDestination())) continue;
                String linkType = UMLVisualIDRegistry.getType(nextLinkDescriptor.getVisualID());
                Edge edge = ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), (View)diagram, linkType, -1, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (edge == null) continue;
                edge.setSource((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getSource()));
                edge.setTarget((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getDestination()));
                it.remove();
                if (nextLinkDescriptor.getModelElement() != null) {
                    this.myDomain2NotationMap.put(nextLinkDescriptor.getModelElement(), edge);
                }
                continueLinkCreation = true;
                switch (nextLinkDescriptor.getVisualID()) {
                    case 1013: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getExtension_1013OutgoingLinks((View)edge));
                        break;
                    }
                    case 4001: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getAssociation_4001OutgoingLinks((View)edge));
                        break;
                    }
                    case 1045: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getProfileApplication_1045OutgoingLinks((View)edge));
                        break;
                    }
                    case 4019: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getAssociation_4019OutgoingLinks((View)edge));
                        break;
                    }
                    case 4002: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getGeneralization_4002OutgoingLinks((View)edge));
                        break;
                    }
                    case 4008: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getDependency_4008OutgoingLinks((View)edge));
                        break;
                    }
                    case 4018: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getDependency_4018OutgoingLinks((View)edge));
                        break;
                    }
                    case 1064: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getElementImport_1064OutgoingLinks((View)edge));
                        break;
                    }
                    case 1065: {
                        additionalDescriptors.addAll(UMLDiagramUpdater.getPackageImport_1065OutgoingLinks((View)edge));
                    }
                }
            }
            this.myLinkDescriptors.addAll(additionalDescriptors);
        }
    }

    private Node getCompartment(View node, int visualID) {
        String type = UMLVisualIDRegistry.getType(visualID);
        for (View nextView : node.getChildren()) {
            if (!(nextView instanceof Node) || !type.equals(nextView.getType())) continue;
            return (Node)nextView;
        }
        return null;
    }
}

