/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.service;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.infra.core.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.core.lifecycleevents.ISaveEventListener;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.validation.ValidationTool;
import org.eclipse.papyrus.uml.diagram.profile.custom.commands.DefineProfileCommand;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileDefinitionDialog;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;

public class PreSaveProfileListener
implements ISaveEventListener {
    public void doSave(DoSaveEvent event) {
        try {
            Profile rootProfile = null;
            ServicesRegistry registry = event.getServiceRegistry();
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)registry);
            IModel umlModel = modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
            EObject profileEObject = null;
            if (umlModel != null) {
                profileEObject = ((UmlModel)umlModel).lookupRoot();
            }
            if (profileEObject instanceof Profile) {
                rootProfile = (Profile)profileEObject;
            }
            if (rootProfile == null) {
                return;
            }
            String DEFINE_MSG = "In order to apply this profile, it had to be defined.\nWould you like to define it?";
            String PAPYRUS_QUESTION = "Papyrus question";
            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean result = MessageDialog.openQuestion((Shell)activeShell, (String)PAPYRUS_QUESTION, (String)DEFINE_MSG);
            if (!result) {
                return;
            }
            ProfileDefinitionDialog dialog = new ProfileDefinitionDialog(activeShell, rootProfile);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                PapyrusDefinitionAnnotation papyrusAnnotation = dialog.getPapyrusDefinitionAnnotation();
                TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)registry);
                AdapterFactory adapterFactory = domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)domain).getAdapterFactory() : null;
                Diagnostician diagnostician = this.createDiagnostician(adapterFactory, (IProgressMonitor)new NullProgressMonitor());
                BasicDiagnostic diagnostic = diagnostician.createDefaultDiagnostic((EObject)rootProfile);
                diagnostic.getSeverity();
                Map context = diagnostician.createDefaultContext();
                diagnostician.validate((EObject)rootProfile, (DiagnosticChain)diagnostic, context);
                if (this.canDefine((Diagnostic)diagnostic)) {
                    DefineProfileCommand cmd = new DefineProfileCommand(domain, papyrusAnnotation, rootProfile, dialog.saveConstraintInDefinition());
                    try {
                        IStatus status = CheckedOperationHistory.getInstance().execute((IUndoableOperation)cmd, (IProgressMonitor)new NullProgressMonitor(), null);
                        switch (status.getSeverity()) {
                            case 0: {
                                MessageDialog.openInformation((Shell)activeShell, (String)"The profile has been defined", (String)"The profile has been successfully defined");
                                break;
                            }
                            case 2: {
                                Activator.log.warn(status.getMessage());
                                MessageDialog.openWarning((Shell)activeShell, (String)"The profile has been defined", (String)status.getMessage());
                                break;
                            }
                            case 4: {
                                this.notifyErrors(activeShell, cmd.getDiagnostic());
                            }
                        }
                    }
                    catch (ExecutionException e) {
                        Activator.log.error((Throwable)e);
                        MessageDialog.openError((Shell)activeShell, (String)"Uncaught exception", (String)("An exception occurred during the profile definition: \n" + e.getMessage()));
                    }
                } else {
                    this.handleDiagnostic((Diagnostic)diagnostic, rootProfile);
                    MessageDialog.openError((Shell)activeShell, (String)"Profile not Valid", (String)"The profile cannot be defined because it is invalid.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void notifyErrors(Shell activeShell, Diagnostic diagnostic) {
        Activator.log.error(diagnostic.getMessage(), diagnostic.getException());
        DiagnosticDialog.openProblem((Shell)activeShell, (String)"Profile definition failed", (String)"The following errors occured during the profile definition", (Diagnostic)diagnostic);
    }

    protected boolean canDefine(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        if (severity == 8) {
            return false;
        }
        if (severity == 4) {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (childDiagnostic.getSeverity() != 4 || childDiagnostic.getData().isEmpty() || !(childDiagnostic.getData().get(0) instanceof Element)) continue;
                return false;
            }
        }
        return true;
    }

    protected Diagnostician createDiagnostician(final AdapterFactory adapterFactory, final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }

    protected void handleDiagnostic(Diagnostic diagnostic, Profile profil) {
        Resource resource = profil.eResource();
        if (resource != null) {
            if (profil != null) {
                ValidationTool vt = new ValidationTool((EObject)profil);
                vt.deleteSubMarkers();
            }
            ValidateAction.EclipseResourcesUtil eclipseResourcesUtil = new ValidateAction.EclipseResourcesUtil();
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
            }
        }
    }

    public void doSaveAs(DoSaveEvent event) {
    }
}

