/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.InteractionOperandCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.providers.ElementInitializers;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomInteractionOperandCreateCommand
extends InteractionOperandCreateCommand {
    public CustomInteractionOperandCreateCommand(CreateElementRequest req, EObject eObject) {
        super(req, eObject);
    }

    public CustomInteractionOperandCreateCommand(CreateElementRequest req) {
        super(req);
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CombinedFragment owner = (CombinedFragment)this.getElementToEdit();
        Set coveredInteractionFragments = (Set)this.getRequest().getParameters().get("Covered InteractionFragments");
        InteractionOperand newElement = CustomInteractionOperandCreateCommand.createInteractionOperand(owner, coveredInteractionFragments);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    public static InteractionOperand createInteractionOperand(CombinedFragment cf, Set<InteractionFragment> coveredInteractionFragments) {
        InteractionOperand newIO = UMLFactory.eINSTANCE.createInteractionOperand();
        cf.getOperands().add((Object)newIO);
        String base = newIO.eClass().getName();
        String name = ElementInitializers.getNextNumberedName((Collection)cf.getOperands(), base);
        newIO.setName(name);
        for (InteractionOperand operand : cf.getOperands()) {
            operand.getCovereds().addAll((Collection)cf.getCovereds());
        }
        InteractionConstraint guard = UMLFactory.eINSTANCE.createInteractionConstraint();
        newIO.setGuard(guard);
        LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
        literalString.setValue("undefined");
        guard.setSpecification((ValueSpecification)literalString);
        LiteralInteger min = UMLFactory.eINSTANCE.createLiteralInteger();
        min.setValue(0);
        guard.setMinint((ValueSpecification)min);
        LiteralInteger max = UMLFactory.eINSTANCE.createLiteralInteger();
        max.setValue(1);
        guard.setMaxint((ValueSpecification)max);
        if (coveredInteractionFragments != null) {
            InteractionOperand cfOwner = null;
            if (cf.getEnclosingOperand() != null) {
                cfOwner = cf.getEnclosingOperand();
            } else if (cf.getEnclosingInteraction() != null) {
                cfOwner = cf.getEnclosingInteraction();
            }
            if (cfOwner != null) {
                for (InteractionFragment ift : coveredInteractionFragments) {
                    if (!cfOwner.equals(ift.getEnclosingOperand()) && !cfOwner.equals(ift.getEnclosingInteraction())) continue;
                    ift.setEnclosingInteraction(null);
                    ift.setEnclosingOperand(newIO);
                }
            }
        }
        return newIO;
    }
}

