/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.Message2CreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.MessageConnectionHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;

public class CustomMessage2CreateCommand
extends Message2CreateCommand {
    private static final String CREATE_LINK_ERROR_MSG = "Invalid arguments in create link command";
    private static final String NO_CONTAINER_ERROR_MSG = "There is now valid container for events";

    public CustomMessage2CreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request, source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Element)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Element)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        if (this.getSource() != null && this.getTarget() != null && !CommandHelper.hasValidContainer(this.getRequest())) {
            return false;
        }
        if (!UMLBaseItemSemanticEditPolicy.getLinkConstraints().canCreateMessage_4004(this.getContainer(), this.getSource(), this.getTarget())) {
            return false;
        }
        return MessageConnectionHelper.canExist(MessageSort.ASYNCH_CALL_LITERAL, this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException(CREATE_LINK_ERROR_MSG);
        }
        Map parameters = this.getRequest().getParameters();
        Message message = CommandHelper.doCreateMessage(this.container, null, this.getSource(), this.getTarget(), parameters);
        if (message == null || message.getSendEvent() == null || message.getReceiveEvent() == null) {
            return CommandResult.newErrorCommandResult((String)"Failed to create message");
        }
        if (message != null) {
            ExecutionSpecification execution;
            if (this.getTarget() instanceof ExecutionSpecification) {
                OccurrenceSpecificationHelper.resetExecutionStart((ExecutionSpecification)this.getTarget(), (Element)message.getReceiveEvent());
            }
            if (this.getSource() instanceof ExecutionOccurrenceSpecification && (execution = ((ExecutionOccurrenceSpecification)this.getSource()).getExecution()) != null) {
                OccurrenceSpecificationHelper.resetExecutionStart(execution, (Element)message.getSendEvent());
            }
            this.doConfigure(message, monitor, info);
            ((CreateElementRequest)this.getRequest()).setNewElement((EObject)message);
            return CommandResult.newOKCommandResult((Object)message);
        }
        return CommandResult.newErrorCommandResult((String)NO_CONTAINER_ERROR_MSG);
    }
}

