/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLConnectionNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.edge.UMLEdgeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message6EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message7EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageEndEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.InteractionFragmentsOrderingEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineChildGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.MessageLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.MessageFigure;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.SelfMessageHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Message;

public abstract class AbstractMessageEditPart
extends UMLConnectionNodeEditPart {
    private List messageEventParts;
    private MouseMoveListener mouseMoveListener;
    private Cursor myCursor;
    private Cursor defaultCursor;

    public AbstractMessageEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        if (this.getTarget() == null || this.getSource() == null) {
            this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    AbstractMessageEditPart.this.hookGraphicalViewer();
                }
            });
        } else {
            this.hookGraphicalViewer();
        }
    }

    private void hookGraphicalViewer() {
        if (SelfMessageHelper.isSelfLink(this)) {
            this.mouseMoveListener = new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    AbstractMessageEditPart.this.handleMouseMoved(e.x, e.y);
                }
            };
            this.getViewer().getControl().addMouseMoveListener(this.mouseMoveListener);
        }
    }

    protected void handleMouseMoved(int x, int y) {
        this.myCursor = null;
        if (this.defaultCursor != null) {
            this.getViewer().setCursor(Cursors.ARROW);
            this.defaultCursor = null;
        }
        if (!SelfMessageHelper.isSelfLink(this)) {
            return;
        }
        MessageFigure primaryShape = this.getPrimaryShape();
        Point p = new Point(x, y);
        primaryShape.translateToRelative((Translatable)p);
        if (!primaryShape.containsPoint(p.x, p.y)) {
            return;
        }
        PointList points = primaryShape.getPoints();
        if (points.size() <= 1) {
            return;
        }
        List lineSegments = PointListUtilities.getLineSegments((PointList)points);
        LineSeg nearestSegment = PointListUtilities.getNearestSegment((List)lineSegments, (int)p.x, (int)p.y);
        this.myCursor = points.size() > 3 && (p.getDistance(points.getPoint(1)) < 5.0 || p.getDistance(points.getPoint(2)) < 5.0) ? Cursors.SIZEALL : (nearestSegment.isHorizontal() ? Cursors.SIZENS : Cursors.SIZEWE);
        this.defaultCursor = this.getViewer().getControl().getCursor();
        this.getViewer().setCursor(this.myCursor);
        if (SelfMessageHelper.isSelfLink(this)) {
            this.getPrimaryShape().setCustomCursor(this.myCursor);
        } else {
            this.getPrimaryShape().setCustomCursor(null);
        }
    }

    public abstract MessageFigure getPrimaryShape();

    public void deactivate() {
        if (this.mouseMoveListener != null) {
            this.getViewer().getControl().removeMouseMoveListener(this.mouseMoveListener);
        }
        super.deactivate();
    }

    private Cursor getCustomCursor() {
        if (!SelfMessageHelper.isSelfLink(this)) {
            return null;
        }
        return this.myCursor;
    }

    protected int getLineWidth() {
        int lineWidth = super.getLineWidth();
        return lineWidth < 0 ? 1 : lineWidth;
    }

    protected void fireSelectionChanged() {
        super.fireSelectionChanged();
        MessageFigure primaryShape = this.getPrimaryShape();
        if (primaryShape instanceof MessageFigure) {
            primaryShape.setSelection(this.getSelected() != 0);
        }
    }

    public View findChildByModel(EObject model) {
        List list = this.getModelChildren();
        if (list != null && list.size() > 0) {
            for (Object o : list) {
                View view;
                if (!(o instanceof View) || (view = (View)o).getElement() != model) continue;
                return view;
            }
        }
        return null;
    }

    public List getChildren() {
        if (this.messageEventParts == null) {
            this.initMessageEventPart();
        }
        return super.getChildren();
    }

    protected void initMessageEventPart() {
        this.messageEventParts = new ArrayList();
        String id = String.valueOf(999999);
        List list = this.getModelChildren();
        for (Object o : list) {
            Shape s;
            if (!(o instanceof Shape) || !(s = (Shape)o).getType().equals(id)) continue;
            return;
        }
        EObject element = this.resolveSemanticElement();
        if (!(element instanceof Message)) {
            return;
        }
        Message message = (Message)element;
        UMLEdgeFigure edgeFigure = (UMLEdgeFigure)this.getFigure();
        Diagram diagram = ((View)this.getModel()).getDiagram();
        if (!(message.getSendEvent() instanceof Gate)) {
            MessageEndEditPart sendEventPart = new MessageEndEditPart(message.getSendEvent(), this, new ConnectionLocator((Connection)edgeFigure, 2));
            this.messageEventParts.add(sendEventPart);
            sendEventPart.rebuildLinks(diagram);
            this.addChild((EditPart)sendEventPart, -1);
        }
        if (!(message.getReceiveEvent() instanceof Gate)) {
            MessageEndEditPart receiveEventPart = new MessageEndEditPart(message.getReceiveEvent(), this, new ConnectionLocator((Connection)edgeFigure, 3));
            this.messageEventParts.add(receiveEventPart);
            receiveEventPart.rebuildLinks(diagram);
            this.addChild((EditPart)receiveEventPart, -1);
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("MaskManagedLabelPolicy", (EditPolicy)new MessageLabelEditPolicy());
        this.installEditPolicy("Ordering Interaction Fragments", (EditPolicy)new InteractionFragmentsOrderingEditPolicy());
    }

    public EditPart getTargetEditPart(Request request) {
        org.eclipse.gef.ConnectionEditPart con;
        List types;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest ? (types = ((CreateUnspecifiedTypeConnectionRequest)request).getElementTypes()).contains(UMLElementTypes.Message_4009) || types.contains(UMLElementTypes.Message_4008) : request instanceof ReconnectRequest && ((con = ((ReconnectRequest)request).getConnectionEditPart()) instanceof Message7EditPart || con instanceof Message6EditPart)) {
            return null;
        }
        return super.getTargetEditPart(request);
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        MessageLabelEditPart labelPart = this.getMessageLabelEditPart();
        if (labelPart == null) {
            return;
        }
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            labelPart.refreshFontColor();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            labelPart.refreshFont();
        }
    }

    public MessageLabelEditPart getMessageLabelEditPart() {
        for (Object c : this.getChildren()) {
            if (!(c instanceof MessageLabelEditPart)) continue;
            return (MessageLabelEditPart)((Object)c);
        }
        return null;
    }

    public void setLineWidth(int width) {
        if (this.getPrimaryShape() instanceof MessageFigure) {
            MessageFigure edge = this.getPrimaryShape();
            edge.setLineWidth(width);
        }
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().showSourceFeedback(request);
            this.getTarget().showSourceFeedback(request);
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().eraseSourceFeedback(request);
            this.getTarget().eraseSourceFeedback(request);
        }
        super.eraseSourceFeedback(request);
    }

    protected void installRouter() {
        this.getConnectionFigure().setConnectionRouter(LifelineChildGraphicalNodeEditPolicy.messageRouter);
        this.getConnectionFigure().setCursor(org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors.CURSOR_SEG_MOVE);
        this.refreshBendpoints();
    }

    protected void refreshRoutingStyles() {
    }

    static abstract class MessageLabelEditPart
    extends LabelEditPart {
        public MessageLabelEditPart(View view) {
            super(view);
        }

        protected void handleNotificationEvent(Notification notification) {
            Object feature = notification.getFeature();
            if (NotationPackage.eINSTANCE.getLineStyle_LineColor().equals(feature)) {
                this.refreshFontColor();
            } else {
                super.handleNotificationEvent(notification);
            }
        }

        public void refreshFontColor() {
            FontStyle style = (FontStyle)((ConnectionEditPart)this.getParent()).getPrimaryView().getStyle(NotationPackage.Literals.FONT_STYLE);
            if (style != null) {
                this.setFontColor(DiagramColorRegistry.getInstance().getColor(Integer.valueOf(style.getFontColor())));
            }
        }

        protected void refreshFont() {
            super.refreshFont();
        }
    }
}

