/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.StateInvariantEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomStateInvariantItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.locator.CenterLocator;

public class CustomStateInvariantEditPart
extends StateInvariantEditPart {
    public CustomStateInvariantEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomStateInvariantItemSemanticEditPolicy());
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        if (this.getModel() != null && this.getModel() == notification.getNotifier() && NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineWidth();
        this.refreshTransparency();
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void refreshBounds() {
        if (this.getBorderItemLocator() != null) {
            int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            Point loc = new Point(x, y);
            int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension size = new Dimension(width, height);
            this.getFigure().setBounds(new Rectangle(loc, size));
            this.getBorderItemLocator().setConstraint(new Rectangle(loc, size));
        } else {
            super.refreshBounds();
        }
    }

    public StateInvariantFigure getPrimaryShape() {
        return (StateInvariantFigure)this.primaryShape;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new StateInvariantFigure();
        return this.primaryShape;
    }

    public class StateInvariantFigure
    extends StateInvariantEditPart.ContinuationFigure {
        private int transparency;

        public StateInvariantFigure() {
            super(CustomStateInvariantEditPart.this);
            this.transparency = 0;
        }

        protected void fillShape(Graphics graphics) {
            graphics.pushState();
            this.applyTransparency(graphics);
            graphics.fillRoundRectangle(this.getBounds(), this.corner.width, this.corner.height);
            graphics.popState();
        }

        public int getTransparency() {
            return this.transparency;
        }

        public void setTransparency(int transparency) {
            if (transparency != this.transparency && transparency >= 0 && transparency <= 100) {
                this.transparency = transparency;
                this.repaint();
            }
        }

        protected void applyTransparency(Graphics g) {
            g.setAlpha(255 - this.transparency * 255 / 100);
        }
    }

    static class StateInvariantLocator
    extends CenterLocator {
        public StateInvariantLocator(IFigure parentFigure, int location) {
            super(parentFigure, location);
        }

        public void relocate(IFigure borderItem) {
            Point constraintLocation = this.getConstraint().getLocation();
            Dimension size = this.getSize(borderItem);
            Point ptNewLocation = new Point(this.getParentBorder().getCenter().x - size.width / 2, constraintLocation.y);
            borderItem.setBounds(new Rectangle(ptNewLocation, size));
        }

        public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
            Rectangle realLocation = new Rectangle(proposedLocation);
            Point point = new Point(this.getParentBorder().getCenter().x - realLocation.getSize().width / 2, realLocation.y);
            realLocation.setLocation(point);
            return realLocation;
        }
    }

    public static class StateInvariantResizableEditPolicy
    extends BorderItemResizableEditPolicy {
        protected Command getResizeCommand(ChangeBoundsRequest request) {
            IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
            IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
            if (borderItemLocator != null) {
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                this.getHostFigure().translateToRelative((Translatable)rect);
                Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
                if (borderItemEP.getParent() instanceof LifelineEditPart && !this.restrictInParentBounds((LifelineEditPart)borderItemEP.getParent(), borderItemEP, realLocation.getCopy())) {
                    return null;
                }
                SetBoundsCommand moveCommand = new SetBoundsCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), realLocation);
                return new ICommandProxy((ICommand)moveCommand);
            }
            return null;
        }

        protected Command getMoveCommand(ChangeBoundsRequest request) {
            IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
            IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
            if (borderItemLocator != null) {
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                this.getHostFigure().translateToRelative((Translatable)rect);
                Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
                if (borderItemEP.getParent() instanceof LifelineEditPart && !this.restrictInParentBounds((LifelineEditPart)borderItemEP.getParent(), borderItemEP, realLocation.getCopy())) {
                    return null;
                }
                Point location = realLocation.getTopLeft();
                SetBoundsCommand moveCommand = new SetBoundsCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), location);
                return new ICommandProxy((ICommand)moveCommand);
            }
            return null;
        }

        private boolean restrictInParentBounds(LifelineEditPart ep, IBorderItemEditPart borderItemEP, Rectangle realLocation) {
            borderItemEP.getFigure().translateToAbsolute((Translatable)realLocation);
            Rectangle bounds = ep.getPrimaryShape().getBounds().getCopy();
            ep.getPrimaryShape().translateToAbsolute((Translatable)bounds);
            int nameHeight = ep.getPrimaryShape().getFigureLifelineNameContainerFigure().getBounds().height;
            if (realLocation.y - nameHeight < bounds.y) {
                return false;
            }
            return realLocation.getBottom().y <= bounds.getBottom().y;
        }
    }
}

