/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.ElementCreationWithMessageEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class ExecutionGraphicalNodeEditPolicy
extends ElementCreationWithMessageEditPolicy {
    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Command command = super.getReconnectSourceCommand(request);
        if (command != null && command.canExecute() && !this.relationshipSourceHasChanged(request)) {
            command = this.appendUpdateExecutionEndCommand(request, command, false);
        }
        return command;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command command = super.getReconnectTargetCommand(request);
        if (command != null && command.canExecute() && !this.relationshipTargetHasChanged(request)) {
            command = this.appendUpdateExecutionEndCommand(request, command, true);
        }
        return command;
    }

    private Command appendUpdateExecutionEndCommand(ReconnectRequest request, Command command, boolean messageTarget) {
        EObject elt;
        EObject elt2;
        EditPart target = request.getTarget();
        ExecutionSpecification execution = null;
        if (target instanceof AbstractExecutionSpecificationEditPart && (elt2 = ((AbstractExecutionSpecificationEditPart)target).resolveSemanticElement()) instanceof ExecutionSpecification) {
            execution = (ExecutionSpecification)elt2;
        }
        MessageEnd messageEnd = null;
        ConnectionEditPart conn = request.getConnectionEditPart();
        if (conn instanceof AbstractMessageEditPart && (elt = ((AbstractMessageEditPart)conn).resolveSemanticElement()) instanceof Message) {
            MessageEnd messageEnd2 = messageEnd = messageTarget ? ((Message)elt).getReceiveEvent() : ((Message)elt).getSendEvent();
        }
        if (execution != null && messageEnd != null) {
            OccurrenceSpecification start = execution.getStart();
            OccurrenceSpecification finish = execution.getFinish();
            if (start != null && start == messageEnd) {
                command = command.chain((Command)new ICommandProxy((ICommand)new ResetExecutionEndCommand(((IGraphicalEditPart)target).getEditingDomain(), execution, true)));
            } else if (finish != null && finish == messageEnd) {
                command = command.chain((Command)new ICommandProxy((ICommand)new ResetExecutionEndCommand(((IGraphicalEditPart)target).getEditingDomain(), execution, false)));
            }
        }
        return command;
    }

    private boolean relationshipSourceHasChanged(ReconnectRequest request) {
        return !request.getConnectionEditPart().getSource().equals(request.getTarget());
    }

    private boolean relationshipTargetHasChanged(ReconnectRequest request) {
        return !request.getConnectionEditPart().getTarget().equals(request.getTarget());
    }

    private static class ResetExecutionEndCommand
    extends AbstractTransactionalCommand {
        private ExecutionSpecification execution;
        private boolean resetStart;

        public ResetExecutionEndCommand(TransactionalEditingDomain domain, ExecutionSpecification execution, boolean resetStart) {
            super(domain, "", null);
            this.execution = execution;
            this.resetStart = resetStart;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.execution != null) {
                if (this.resetStart) {
                    OccurrenceSpecificationHelper.resetExecutionStart(this.execution, (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
                } else {
                    OccurrenceSpecificationHelper.resetExecutionFinish(this.execution, (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
                }
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

