/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandUtilities;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.SuppressibleUIRequest;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateGateElementAndViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.ReconnectToGateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionUseEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.locator.GateLocator;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.uml2.uml.Message;

public class GatesHolderGraphicalNodeEditPolicy
extends SequenceGraphicalNodeEditPolicy {
    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        ConnectionEditPart connection = request.getConnectionEditPart();
        EditPart source = connection.getSource();
        if (source instanceof GateEditPart) {
            if (this.getHost() == source.getParent()) {
                return this.getMoveGateCommand((GateEditPart)source, request);
            }
            if (this.isReconnectMessage(request) && !this.isRedirectFailed(request)) {
                Point location = GateHelper.computeGateLocation(request.getLocation(), this.getHostFigure(), null);
                CompositeCommand result = new CompositeCommand("");
                CreateGateElementAndViewCommand createGateCommand = new CreateGateElementAndViewCommand(this.getEditingDomain(), (IAdaptable)this.getHost(), location);
                createGateCommand.setCreateInnerCFGate(this.getHost() instanceof CombinedFragmentEditPart);
                result.add((IUndoableOperation)createGateCommand);
                ReconnectToGateCommand reconnectTargetCommand = new ReconnectToGateCommand(this.getEditingDomain(), this.getHost().getViewer(), createGateCommand.getResult(), request);
                result.add((IUndoableOperation)reconnectTargetCommand);
                return new ICommandProxy((ICommand)result);
            }
        }
        return super.getReconnectSourceCommand(request);
    }

    protected Command getMoveGateCommand(GateEditPart gateEditPart, ReconnectRequest request) {
        Rectangle newBounds = new Rectangle(request.getLocation(), GateEditPart.DEFAULT_SIZE);
        IFigure hostFigure = this.getHostFigure();
        hostFigure.translateToRelative((Translatable)newBounds);
        GateLocator locator = new GateLocator(hostFigure);
        Rectangle validLocation = locator.getValidLocation(newBounds, gateEditPart.getFigure());
        SetBoundsCommand command = new SetBoundsCommand(this.getEditingDomain(), "Update Gate Location", (IAdaptable)new EObjectAdapter((EObject)gateEditPart.getNotationView()), validLocation.getLocation());
        return new ICommandProxy((ICommand)command);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        ConnectionEditPart connection = request.getConnectionEditPart();
        EditPart target = connection.getTarget();
        if (target instanceof GateEditPart) {
            if (this.getHost() == target.getParent()) {
                return this.getMoveGateCommand((GateEditPart)target, request);
            }
            if (this.isReconnectMessage(request) && !this.isRedirectFailed(request)) {
                Point location = GateHelper.computeGateLocation(request.getLocation(), this.getHostFigure(), null);
                CompositeCommand result = new CompositeCommand("");
                CreateGateElementAndViewCommand createGateCommand = new CreateGateElementAndViewCommand(this.getEditingDomain(), (IAdaptable)this.getHost(), location);
                createGateCommand.setCreateInnerCFGate(this.getHost() instanceof CombinedFragmentEditPart);
                result.add((IUndoableOperation)createGateCommand);
                ReconnectToGateCommand reconnectTargetCommand = new ReconnectToGateCommand(this.getEditingDomain(), this.getHost().getViewer(), createGateCommand.getResult(), request);
                result.add((IUndoableOperation)reconnectTargetCommand);
                return new ICommandProxy((ICommand)result);
            }
        }
        return super.getReconnectTargetCommand(request);
    }

    private boolean isRedirectFailed(ReconnectRequest request) {
        Object data = request.getExtendedData().get("Reconnect to gate failed.");
        return data != null && "true".equalsIgnoreCase(data.toString());
    }

    private boolean isReconnectMessage(ReconnectRequest request) {
        ConnectionEditPart conn = request.getConnectionEditPart();
        IGraphicalEditPart adapter = (IGraphicalEditPart)conn.getAdapter(IGraphicalEditPart.class);
        return adapter != null && adapter.resolveSemanticElement() instanceof Message;
    }

    public Command getCommand(Request request) {
        if ("connection end".equals(request.getType()) && (this.isCreatingMessage(request, UMLElementTypes.Message_4004) || this.isCreatingMessage(request, UMLElementTypes.Message_4005) || this.isCreatingMessage(request, UMLElementTypes.Message_4009))) {
            return this.getConnectionEndWithGateCommand((CreateConnectionRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getConnectionEndWithGateCommand(CreateConnectionRequest request) {
        EditPart sourceEditPart;
        CompoundCommand cc = new CompoundCommand(DiagramUIMessages.Command_CreateRelationship_Label);
        Point targetLocation = GateHelper.computeGateLocation(request.getLocation(), this.getHostFigure(), null);
        CreateGateElementAndViewCommand createTargetGateCommand = new CreateGateElementAndViewCommand(this.getEditingDomain(), (IAdaptable)this.getHost(), targetLocation);
        createTargetGateCommand.setCreateInnerCFGate(true);
        createTargetGateCommand.setVolatiled(!(this.getHost() instanceof InteractionEditPart));
        cc.add((Command)new ICommandProxy((ICommand)createTargetGateCommand));
        IAdaptable targetViewAdapter = createTargetGateCommand.getResult();
        EditPart sourceViewAdapter = sourceEditPart = request.getSourceEditPart();
        if (!this.isCreatingMessage((Request)request, UMLElementTypes.Message_4009) && (sourceEditPart instanceof CombinedFragmentEditPart || sourceEditPart instanceof InteractionEditPart || sourceEditPart instanceof InteractionUseEditPart)) {
            IGraphicalEditPart ep = (IGraphicalEditPart)sourceEditPart;
            Point location = request.getLocation();
            Object locationData = request.getExtendedData().get("Location of connection source point");
            if (locationData instanceof Point) {
                location = (Point)locationData;
            }
            Point sourceLocation = GateHelper.computeGateLocation(location, ep.getFigure(), null);
            CreateGateElementAndViewCommand createSourceGateCommand = new CreateGateElementAndViewCommand(this.getEditingDomain(), (IAdaptable)sourceViewAdapter, sourceLocation);
            createSourceGateCommand.setCreateInnerCFGate(true);
            createSourceGateCommand.setVolatiled(!(sourceEditPart instanceof InteractionEditPart));
            cc.add((Command)new ICommandProxy((ICommand)createSourceGateCommand));
            sourceViewAdapter = createSourceGateCommand.getResult();
        }
        ICommand createMessageCommand = this.createCreateMessageWithGateCommand(request, (IAdaptable)sourceViewAdapter, targetViewAdapter);
        cc.add((Command)new ICommandProxy(createMessageCommand));
        return cc;
    }

    protected ICommand createCreateMessageWithGateCommand(CreateConnectionRequest request, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter) {
        CreateUnspecifiedTypeConnectionRequest createReq;
        List elementTypes;
        if (request instanceof CreateConnectionViewAndElementRequest) {
            return new CreateMessageWithGateCommand((CreateConnectionViewAndElementRequest)request, sourceViewAdapter, targetViewAdapter, this.getHost().getViewer());
        }
        if (request instanceof CreateUnspecifiedTypeConnectionRequest && (elementTypes = (createReq = (CreateUnspecifiedTypeConnectionRequest)request).getElementTypes()).size() == 1) {
            IElementType elementType = (IElementType)elementTypes.get(0);
            return new CreateMessageWithGateCommand((CreateRequest)request, (IAdaptable)elementType, sourceViewAdapter, targetViewAdapter, this.getHost().getViewer());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean isCreatingMessage(Request request, IElementType elementType) {
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            return ((CreateUnspecifiedTypeConnectionRequest)request).getElementTypes().contains(elementType);
        }
        if (elementType instanceof IHintedType && request instanceof CreateConnectionViewAndElementRequest) {
            return ((IHintedType)elementType).getSemanticHint().equals(((CreateConnectionViewAndElementRequest)request).getConnectionViewDescriptor().getSemanticHint());
        }
        return false;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((GraphicalEditPart)this.getHost()).getEditingDomain();
    }

    public static Command getCreateCommand(CreateConnectionViewRequest request, EditPart sourceEditPart, EditPart targetEditPart) {
        Assert.isNotNull((Object)request);
        Assert.isNotNull((Object)sourceEditPart);
        Assert.isNotNull((Object)targetEditPart);
        request.setSourceEditPart(sourceEditPart);
        request.setTargetEditPart(targetEditPart);
        request.setType((Object)"connection start");
        Object location = request.getExtendedData().get("Location of connection source point");
        if (location instanceof Point) {
            request.setLocation((Point)location);
        }
        sourceEditPart.showTargetFeedback((Request)request);
        sourceEditPart.getCommand((Request)request);
        sourceEditPart.eraseTargetFeedback((Request)request);
        request.setType((Object)"connection end");
        targetEditPart.showTargetFeedback((Request)request);
        Command command = targetEditPart.getCommand((Request)request);
        targetEditPart.eraseTargetFeedback((Request)request);
        return command;
    }

    private static class CreateMessageWithGateCommand
    extends AbstractCommand {
        private CreateRequest request = null;
        private IAdaptable typeInfoAdapter = null;
        private IAdaptable sourceViewAdapter = null;
        private IAdaptable targetViewAdapter = null;
        private Command command = null;
        private EditPartViewer viewer = null;

        public CreateMessageWithGateCommand(CreateConnectionViewAndElementRequest request, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer currentViewer) {
            super(DiagramUIMessages.Commands_CreateCommand_Connection_Label, null);
            Assert.isNotNull((Object)currentViewer, (String)"currentViewer is null");
            this.request = request;
            this.sourceViewAdapter = sourceViewAdapter;
            this.targetViewAdapter = targetViewAdapter;
            this.viewer = currentViewer;
        }

        public CreateMessageWithGateCommand(CreateRequest request, IAdaptable typeInfoAdapter, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer currentViewer) {
            super(DiagramUIMessages.Commands_CreateCommand_Connection_Label, null);
            Assert.isNotNull((Object)currentViewer, (String)"currentViewer is null");
            this.request = request;
            this.typeInfoAdapter = typeInfoAdapter;
            this.sourceViewAdapter = sourceViewAdapter;
            this.targetViewAdapter = targetViewAdapter;
            this.viewer = currentViewer;
        }

        public List getAffectedFiles() {
            View view;
            EditPart editpart;
            if (this.viewer != null && (editpart = this.viewer.getRootEditPart().getContents()) instanceof IGraphicalEditPart && (view = (View)editpart.getModel()) != null) {
                IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
                return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
            }
            return super.getAffectedFiles();
        }

        public boolean canUndo() {
            return this.command != null && this.command.canUndo();
        }

        public boolean canRedo() {
            return CommandUtilities.canRedo((Command)this.command);
        }

        protected EditPart getSourceEditPart() {
            return (IGraphicalEditPart)this.viewer.getEditPartRegistry().get(this.sourceViewAdapter.getAdapter(View.class));
        }

        protected EditPart getTargetEditPart() {
            return (IGraphicalEditPart)this.viewer.getEditPartRegistry().get(this.targetViewAdapter.getAdapter(View.class));
        }

        public boolean canExecute() {
            if (!(this.request instanceof CreateConnectionViewRequest) && !(this.request instanceof CreateUnspecifiedTypeConnectionRequest)) {
                return false;
            }
            if (this.request instanceof CreateUnspecifiedTypeConnectionRequest) {
                if (this.typeInfoAdapter == null) {
                    return false;
                }
                IElementType typeInfo = (IElementType)this.typeInfoAdapter.getAdapter(IElementType.class);
                if (typeInfo != null && ((CreateUnspecifiedTypeConnectionRequest)this.request).getRequestForType(typeInfo) == null) {
                    return false;
                }
            }
            return true;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            CreateConnectionViewRequest req = null;
            if (this.request != null) {
                if (this.request instanceof CreateConnectionViewRequest) {
                    req = (CreateConnectionViewRequest)this.request;
                }
            } else {
                return CommandResult.newErrorCommandResult((String)this.getLabel());
            }
            if (this.typeInfoAdapter != null) {
                IElementType typeInfo = (IElementType)this.typeInfoAdapter.getAdapter(IElementType.class);
                if (typeInfo == null) {
                    return CommandResult.newErrorCommandResult((String)this.getLabel());
                }
                if (this.request instanceof CreateUnspecifiedTypeConnectionRequest) {
                    req = (CreateConnectionViewRequest)((CreateUnspecifiedTypeConnectionRequest)this.request).getRequestForType(typeInfo);
                }
            }
            if (this.targetViewAdapter.getAdapter(IGraphicalEditPart.class) == null && req instanceof SuppressibleUIRequest) {
                ((SuppressibleUIRequest)req).setSuppressibleUI(true);
            }
            EditPart sourceEP = this.getSourceEditPart();
            EditPart targetEP = this.getTargetEditPart();
            if (sourceEP == null || targetEP == null) {
                return null;
            }
            this.command = GatesHolderGraphicalNodeEditPolicy.getCreateCommand(req, sourceEP, targetEP);
            if (this.command != null && this.command.canExecute()) {
                this.command.execute();
            }
            this.viewer = null;
            View view = (View)req.getConnectionViewDescriptor().getAdapter(View.class);
            if (view == null) {
                return CommandResult.newCancelledCommandResult();
            }
            if (this.request instanceof CreateConnectionViewRequest) {
                ((CreateConnectionViewRequest)this.request).getConnectionViewDescriptor().setView(view);
            }
            return CommandResult.newOKCommandResult((Object)req.getNewObject());
        }

        public String getLabel() {
            if (this.command != null) {
                return this.command.getLabel();
            }
            return null;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.command != null) {
                this.command.redo();
            }
            return CommandResult.newOKCommandResult();
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.command != null) {
                this.command.undo();
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

