/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.papyrus.uml.diagram.common.figure.edge.UMLEdgeFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public abstract class MessageFigure
extends UMLEdgeFigure {
    private static final Font LABEL_FIGURE_FONT = new Font((Device)Display.getCurrent(), "SANS", 9, 0);
    private WrappingLabel messageLabelFigure;
    private boolean selection;
    private Cursor customCursor;
    private IMapMode mapMode;

    public MessageFigure() {
        this(null);
    }

    public MessageFigure(IMapMode mapMode) {
        this.mapMode = mapMode;
        this.createContents();
        this.setTargetDecoration(this.createTargetDecoration());
    }

    public void setLineWidth(int w) {
        super.setLineWidth(w);
        if (this.getSourceDecoration() instanceof Shape) {
            ((Shape)this.getSourceDecoration()).setLineWidth(w);
        }
        if (this.getTargetDecoration() instanceof Shape) {
            ((Shape)this.getTargetDecoration()).setLineWidth(w);
        }
    }

    public void setForegroundColor(Color c) {
        super.setForegroundColor(c);
        if (this.getSourceDecoration() instanceof Shape) {
            ((Shape)this.getSourceDecoration()).setForegroundColor(c);
            ((Shape)this.getSourceDecoration()).setBackgroundColor(c);
        }
        if (this.getTargetDecoration() instanceof Shape) {
            ((Shape)this.getTargetDecoration()).setForegroundColor(c);
            ((Shape)this.getTargetDecoration()).setBackgroundColor(c);
        }
    }

    protected abstract RotatableDecoration createTargetDecoration();

    protected void createContents() {
        super.createContents();
        this.messageLabelFigure = new WrappingLabel();
        this.messageLabelFigure.setText("");
        this.messageLabelFigure.setForegroundColor(ColorConstants.black);
        this.messageLabelFigure.setFont(LABEL_FIGURE_FONT);
        this.add((IFigure)this.messageLabelFigure);
    }

    public WrappingLabel getMessageLabelFigure() {
        return this.messageLabelFigure;
    }

    public IMapMode getMapMode() {
        if (this.mapMode != null) {
            return this.mapMode;
        }
        return MapModeUtil.getMapMode();
    }

    public boolean isSelection() {
        return this.selection;
    }

    public void setSelection(boolean selection) {
        this.selection = selection;
        this.repaint();
    }

    public Cursor getCustomCursor() {
        return this.customCursor;
    }

    public Cursor getCursor() {
        if (this.customCursor != null) {
            return this.customCursor;
        }
        return super.getCursor();
    }

    public void setCustomCursor(Cursor customCursor) {
        this.customCursor = customCursor;
    }

    public void setMapMode(IMapMode mapMode) {
        this.mapMode = mapMode;
    }
}

