/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class LifelineResizeHelper {
    private static final String MANUAL_LABEL_SIZE = "manual.label.size";
    private static final String CUSTOM_EXTENSION_INFO = "CustomExtensionInfo";

    public static boolean isManualSize(LifelineEditPart lp) {
        View view = lp.getNotationView();
        EAnnotation oldAnnotation = view.getEAnnotation(CUSTOM_EXTENSION_INFO);
        if (oldAnnotation != null) {
            String val = (String)oldAnnotation.getDetails().get((Object)MANUAL_LABEL_SIZE);
            return "true".equalsIgnoreCase(val);
        }
        LifelineFigure primaryShape = lp.getPrimaryShape();
        Dimension namePreSize = primaryShape.getFigureLifelineNameContainerFigure().getPreferredSize();
        Rectangle childrenRect = null;
        List<ShapeNodeEditPart> childShapeNodeEditPart = LifelineEditPartUtil.getChildShapeNodeEditPart(lp);
        for (ShapeNodeEditPart child : childShapeNodeEditPart) {
            if (!(child instanceof AbstractExecutionSpecificationEditPart)) continue;
            Rectangle rect = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)child);
            if (childrenRect == null) {
                childrenRect = rect;
                continue;
            }
            childrenRect.union(rect);
        }
        return childrenRect != null && namePreSize.width / 2 < childrenRect.width - 8;
    }

    public static ICommand createManualLabelSizeCommand(TransactionalEditingDomain domain, IAdaptable adapter) {
        return new ManualLabelSizeCommand(domain, adapter, CUSTOM_EXTENSION_INFO);
    }

    public static ICommand createManualLabelSizeCommand(LifelineEditPart lifelineEP) {
        return new ManualLabelSizeCommand(lifelineEP.getEditingDomain(), (EModelElement)lifelineEP.getNotationView(), CUSTOM_EXTENSION_INFO);
    }

    public static class ManualLabelSizeCommand
    extends AbstractTransactionalCommand {
        private EModelElement object;
        private String eAnnotationName;
        private IAdaptable adapter;

        public EModelElement getObject() {
            if (this.object != null) {
                return this.object;
            }
            if (this.adapter != null) {
                return (View)this.adapter.getAdapter(View.class);
            }
            return null;
        }

        public ManualLabelSizeCommand(TransactionalEditingDomain domain, EModelElement object, String eannotationName) {
            super(domain, "manual size", null);
            this.object = object;
            this.eAnnotationName = eannotationName;
        }

        public ManualLabelSizeCommand(TransactionalEditingDomain domain, IAdaptable adapter, String eannotationName) {
            super(domain, "manual size", null);
            this.adapter = adapter;
            this.eAnnotationName = eannotationName;
        }

        protected EAnnotation createEAnnotation() {
            EAnnotation eannotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eannotation.setSource(this.eAnnotationName);
            return eannotation;
        }

        protected void attachEannotation(EAnnotation annotation, EModelElement object) {
            object.getEAnnotations().add((Object)annotation);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            EAnnotation oldAnnotation = this.getObject().getEAnnotation(this.eAnnotationName);
            if (oldAnnotation == null) {
                oldAnnotation = this.createEAnnotation();
                this.attachEannotation(oldAnnotation, this.getObject());
            }
            oldAnnotation.getDetails().put((Object)LifelineResizeHelper.MANUAL_LABEL_SIZE, (Object)"true");
            return CommandResult.newOKCommandResult();
        }
    }
}

