/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.uml.diagram.sequence.CustomMessages;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOrCreateDialog
extends FormDialog {
    private EObject selectedElement = null;
    private EClass selectedType = null;
    private String selectedName = null;
    private EObject selectedParent = null;
    private Collection<EObject> existingElements;
    private LinkedHashMap<EClass, List<EObject>> mapTypesPossibleParents;
    private Button nothingRadio;
    private Button selectionRadio;
    private Text selectionText;
    private Button selectionButton;
    private Button creationRadio;
    private Text creationNameText;
    private ComboViewer typeComboViewer = null;
    private Combo creationTypeCombo = null;
    private Button creationParentButton;
    private Text creationParentText;
    private String title;
    private ILabelProvider typeLabelProvider;
    private ILabelProvider elementLabelProvider;
    private final TransactionalEditingDomain transactionalEditingDomain;
    private Button filterSignalButton;
    private List<Type> types;

    public SelectOrCreateDialog(Shell shell, String title, ILabelProvider typeLabelProvider, ILabelProvider elementLabelProvider, TransactionalEditingDomain transactionalEditingDomain, Collection<EObject> existingElements, LinkedHashMap<EClass, List<EObject>> mapTypesPossibleParents, List<Type> types) {
        super(shell);
        this.typeLabelProvider = typeLabelProvider;
        this.elementLabelProvider = elementLabelProvider;
        this.existingElements = existingElements;
        this.mapTypesPossibleParents = mapTypesPossibleParents;
        this.title = title;
        this.transactionalEditingDomain = transactionalEditingDomain;
        this.types = types;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.refreshOkButton();
    }

    protected void createFormContent(IManagedForm pForm) {
        ScrolledForm scrolledForm = pForm.getForm();
        scrolledForm.setText(this.title);
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createSelectionSection(scrolledForm.getBody(), toolkit);
        this.createCreationSection(scrolledForm.getBody(), toolkit);
        this.createNothingSection(scrolledForm.getBody(), toolkit);
        this.refreshSectionsEnable(this.selectionRadio);
        this.hookListeners();
        this.setName(null);
        scrolledForm.reflow(true);
    }

    private void createNothingSection(Composite pParent, FormToolkit pToolkit) {
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        lBody.setLayout((Layout)new GridLayout(1, false));
        this.nothingRadio = pToolkit.createButton(lBody, CustomMessages.SelectOrCreateDialog_NothingLabel, 16);
        this.nothingRadio.setSelection(true);
        this.nothingRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    private void createSelectionSection(Composite pParent, FormToolkit pToolkit) {
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        lBody.setLayout((Layout)new GridLayout(3, false));
        this.selectionRadio = pToolkit.createButton(lBody, CustomMessages.SelectOrCreateDialog_SelectLabel, 16);
        this.selectionRadio.setSelection(true);
        this.selectionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.selectionText = pToolkit.createText(lBody, "", 2056);
        this.selectionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.selectionButton = pToolkit.createButton(lBody, "...", 0x800000);
        if (this.existingElements != null) {
            for (EObject next : this.existingElements) {
                if (next == null) continue;
                this.selectionButton.setImage(UMLElementTypes.getImage((ENamedElement)next.eClass()));
                break;
            }
        }
        this.selectionButton.setLayoutData((Object)new GridData(0));
        this.filterSignalButton = pToolkit.createButton(lBody, "filter out all signals which are not receivable", 32);
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    private void createCreationSection(Composite pParent, FormToolkit pToolkit) {
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        lBody.setLayout((Layout)new GridLayout(3, false));
        this.creationRadio = pToolkit.createButton(lBody, CustomMessages.SelectOrCreateDialog_CreateLabel, 16);
        this.creationRadio.setSelection(false);
        this.creationRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        EClass defaultType = null;
        Set<EClass> possibleTypes = this.mapTypesPossibleParents.keySet();
        if (possibleTypes.size() == 1) {
            defaultType = (EClass)possibleTypes.toArray()[0];
        } else {
            pToolkit.createLabel(lBody, CustomMessages.SelectOrCreateDialog_TypeLabel, 0);
            this.creationTypeCombo = new Combo(lBody, 12);
            this.typeComboViewer = new ComboViewer(this.creationTypeCombo);
            pToolkit.adapt((Composite)this.creationTypeCombo);
            this.creationTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.typeComboViewer.setLabelProvider((IBaseLabelProvider)this.typeLabelProvider);
            this.typeComboViewer.add(possibleTypes.toArray());
            if (possibleTypes.size() > 1) {
                defaultType = (EClass)possibleTypes.toArray()[0];
                this.typeComboViewer.setSelection((ISelection)new StructuredSelection((Object)defaultType));
            }
        }
        pToolkit.createLabel(lBody, CustomMessages.SelectOrCreateDialog_NameLabel, 0);
        this.creationNameText = pToolkit.createText(lBody, "", 2048);
        this.creationNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        pToolkit.createLabel(lBody, String.valueOf(CustomMessages.SelectOrCreateDialog_OwnerLabel) + ":", 0);
        this.creationParentText = pToolkit.createText(lBody, this.elementLabelProvider.getText((Object)this.selectedParent), 2056);
        this.creationParentText.setLayoutData((Object)new GridData(768));
        this.creationParentButton = pToolkit.createButton(lBody, "...", 0x800000);
        this.creationParentButton.setLayoutData((Object)new GridData(0));
        this.setType(defaultType);
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    private void hookListeners() {
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectOrCreateDialog.this.refreshSectionsEnable(e.getSource());
                SelectOrCreateDialog.this.refreshOkButton();
            }
        };
        this.selectionRadio.addSelectionListener((SelectionListener)radioListener);
        this.creationRadio.addSelectionListener((SelectionListener)radioListener);
        this.nothingRadio.addSelectionListener((SelectionListener)radioListener);
        SelectionAdapter selectBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectOrCreateDialog.this.handleSelectElement();
            }
        };
        this.selectionButton.addSelectionListener((SelectionListener)selectBtnListener);
        if (this.creationTypeCombo != null && this.typeComboViewer != null) {
            ModifyListener lTypeListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ISelection sel = SelectOrCreateDialog.this.typeComboViewer.getSelection();
                    if (sel instanceof StructuredSelection) {
                        Object type = ((StructuredSelection)sel).getFirstElement();
                        if (type instanceof EClass) {
                            SelectOrCreateDialog.this.setType((EClass)type);
                        } else {
                            SelectOrCreateDialog.this.setType(null);
                        }
                        SelectOrCreateDialog.this.setName(null);
                    }
                }
            };
            this.creationTypeCombo.addModifyListener(lTypeListener);
        }
        ModifyListener lNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectOrCreateDialog.this.selectedName = SelectOrCreateDialog.this.creationNameText.getText();
                SelectOrCreateDialog.this.refreshOkButton();
            }
        };
        this.creationNameText.addModifyListener(lNameListener);
        SelectionAdapter selectParentBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectOrCreateDialog.this.handleSelectParent();
            }
        };
        this.creationParentButton.addSelectionListener((SelectionListener)selectParentBtnListener);
    }

    private void refreshOkButton() {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            if (this.selectionRadio.getSelection()) {
                okButton.setEnabled(this.selectedElement != null);
            } else if (this.nothingRadio.getSelection()) {
                okButton.setEnabled(true);
            } else {
                okButton.setEnabled(this.selectedType != null && this.selectedParent != null && this.selectedName != null && !"".equals(this.selectedName));
            }
        }
    }

    protected void addElementInParent(EObject selectedParent, EObject createdElement) {
        Command addCmd = AddCommand.create((EditingDomain)this.transactionalEditingDomain, (Object)selectedParent, null, Collections.singleton(createdElement));
        if (addCmd.canExecute()) {
            addCmd.execute();
        }
    }

    protected void okPressed() {
        if (this.creationRadio.getSelection()) {
            this.selectedElement = UMLFactory.eINSTANCE.create(this.selectedType);
            if (this.selectedElement instanceof NamedElement) {
                ((NamedElement)this.selectedElement).setName(this.selectedName);
            }
            this.addElementInParent(this.selectedParent, this.selectedElement);
        } else if (this.nothingRadio.getSelection()) {
            this.selectedElement = null;
        }
        super.okPressed();
    }

    private void handleSelectElement() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), this.elementLabelProvider);
        dialog.setMessage(CustomMessages.SelectOrCreateDialog_SelectLabel);
        dialog.setMultipleSelection(false);
        dialog.setElements(this.filterElements(this.existingElements));
        if (dialog.open() == 0) {
            this.setElementSelection((EObject)dialog.getFirstResult());
        }
    }

    private Set<Signal> getAllSignals(List<Type> types) {
        HashSet<Signal> accept = new HashSet<Signal>();
        HashSet<Classifier> collected = new HashSet<Classifier>();
        for (Type t : types) {
            if (!(t instanceof Classifier)) continue;
            Classifier c = (Classifier)t;
            this.collectSignals(c, accept, collected);
        }
        return accept;
    }

    protected void collectSignals(Classifier c, Set<Signal> accept, Set<Classifier> collected) {
        if (collected.contains(c)) {
            return;
        }
        collected.add(c);
        if (c instanceof Class) {
            EList receptions = ((Class)c).getOwnedReceptions();
            for (Reception r : receptions) {
                accept.add(r.getSignal());
            }
        }
        EList attrs = c.getAllAttributes();
        for (Property p : attrs) {
            if (p.getType() instanceof Signal) {
                accept.add((Signal)p.getType());
                continue;
            }
            if (!(p.getType() instanceof Classifier)) continue;
            this.collectSignals((Classifier)p.getType(), accept, collected);
        }
    }

    private Object[] filterElements(Collection<EObject> elements) {
        if (!this.filterSignalButton.getSelection() || this.types == null || this.types.isEmpty()) {
            return elements.toArray(new EObject[elements.size()]);
        }
        Set<Signal> accept = this.getAllSignals(this.types);
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject o : elements) {
            if (!(o instanceof Signal)) {
                result.add(o);
                continue;
            }
            if (!accept.contains(o)) continue;
            result.add(o);
        }
        return result.toArray(new EObject[result.size()]);
    }

    private void handleSelectParent() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), this.elementLabelProvider);
        dialog.setMessage(CustomMessages.SelectOrCreateDialog_OwnerLabel);
        dialog.setMultipleSelection(false);
        List<EObject> possibleParents = this.mapTypesPossibleParents.get(this.selectedType);
        if (possibleParents != null) {
            dialog.setElements(possibleParents.toArray());
        }
        if (dialog.open() == 0) {
            this.setParent((EObject)dialog.getFirstResult());
        }
    }

    private void setParent(EObject parent) {
        this.selectedParent = parent;
        if (this.selectedParent instanceof NamedElement) {
            this.creationParentText.setText(this.elementLabelProvider.getText((Object)this.selectedParent));
            this.creationParentButton.setImage(UMLElementTypes.getImage((ENamedElement)parent.eClass()));
        } else {
            this.creationParentText.setText("");
        }
        this.refreshOkButton();
    }

    private void setName(String name) {
        this.selectedName = name;
        if (name != null) {
            this.creationNameText.setText(name);
        } else {
            this.creationNameText.setText("");
        }
        this.refreshOkButton();
    }

    private void setType(EClass type) {
        this.selectedType = type;
        List<EObject> possibleParents = this.mapTypesPossibleParents.get(type);
        if (possibleParents != null && possibleParents.size() > 0) {
            this.setParent(possibleParents.get(0));
        } else {
            this.setParent(null);
        }
        this.refreshOkButton();
    }

    private void setElementSelection(EObject element) {
        this.selectedElement = element;
        if (this.selectedElement instanceof NamedElement) {
            this.selectionText.setText(this.elementLabelProvider.getText((Object)this.selectedElement));
        } else {
            this.selectionText.setText("");
        }
        this.refreshOkButton();
    }

    private void refreshSectionsEnable(Object radioObject) {
        boolean nothingSelected = false;
        boolean selectionSelected = false;
        boolean creationSelected = false;
        if (this.selectionRadio.equals(radioObject)) {
            selectionSelected = true;
        } else if (this.creationRadio.equals(radioObject)) {
            creationSelected = true;
        } else {
            nothingSelected = true;
        }
        this.selectionRadio.setSelection(selectionSelected);
        this.selectionText.setEnabled(selectionSelected);
        this.selectionButton.setEnabled(selectionSelected);
        this.creationRadio.setSelection(creationSelected);
        if (this.creationTypeCombo != null) {
            this.creationTypeCombo.setEnabled(creationSelected);
        }
        this.creationNameText.setEnabled(creationSelected);
        this.creationParentText.setEnabled(creationSelected);
        this.creationParentButton.setEnabled(creationSelected);
        this.nothingRadio.setSelection(nothingSelected);
    }

    public EObject getSelected() {
        return this.selectedElement;
    }
}

