/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;

public class CustomStateResizeCommand
extends AbstractTransactionalCommand {
    CreateViewRequest.ViewDescriptor viewDescriptor;
    IAdaptable adaptable;
    PreferencesHint prefHints;
    private ChangeBoundsRequest request = null;
    private Rectangle bounds = null;
    private boolean internalResize = false;

    public CustomStateResizeCommand(IAdaptable adaptable, PreferencesHint prefHints, TransactionalEditingDomain domain, String label, ChangeBoundsRequest request, Rectangle bounds, boolean internalResize) {
        super(domain, label, null);
        this.adaptable = adaptable;
        this.prefHints = prefHints;
        this.request = request;
        this.bounds = bounds;
        this.internalResize = internalResize;
        this.viewDescriptor = new CreateViewRequest.ViewDescriptor(adaptable, prefHints);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View state = (View)this.adaptable.getAdapter(View.class);
        View stateLabel = (View)state.getChildren().get(0);
        View stateCompartment = (View)state.getChildren().get(1);
        int direction = this.request.getResizeDirection();
        int dx = this.request.getSizeDelta().width;
        int dy = this.request.getSizeDelta().height;
        for (Node currentNode : state.getChildren()) {
            if (currentNode.getLayoutConstraint() != null) continue;
            currentNode.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        }
        if (this.internalResize) {
            Zone.setHeight(stateLabel, Zone.getHeight(stateLabel) + dy);
        }
        Zone.setBounds(state, this.bounds);
        Zone.setWidth(stateLabel, this.bounds.width);
        Zone.setWidth(stateCompartment, this.bounds.width);
        if (Zone.getHeight(stateLabel) != -1) {
            Zone.setHeight(stateCompartment, this.bounds.height - Zone.getHeight(stateLabel));
        }
        Zone.setY(stateCompartment, Zone.getHeight(stateLabel));
        if (this.internalResize && dx == 0) {
            return CommandResult.newOKCommandResult();
        }
        if (stateCompartment.getChildren().size() == 1) {
            View defaultRegion = (View)stateCompartment.getChildren().get(0);
            Zone.setWidth(defaultRegion, Zone.getWidth(stateCompartment));
            Zone.setHeight(defaultRegion, Zone.getHeight(stateCompartment));
            return CommandResult.newOKCommandResult();
        }
        block11: for (View view : stateCompartment.getChildren()) {
            String zone = Zone.getZone(view);
            switch (direction) {
                case 8: {
                    int width;
                    if (!Zone.hasLeftNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        break;
                    }
                    int x2 = Zone.getX(view);
                    Zone.setX(view, x2 += dx);
                    break;
                }
                case 16: {
                    if (Zone.hasRightNeighbours(zone)) break;
                    int width = Zone.getWidth(view);
                    Zone.setWidth(view, width += dx);
                    break;
                }
                case 1: {
                    int height2;
                    if (!Zone.hasTopNeighbours(zone)) {
                        height2 = Zone.getHeight(view);
                        Zone.setHeight(view, height2 += dy);
                        break;
                    }
                    int y2 = Zone.getY(view);
                    Zone.setY(view, y2 += dy);
                    break;
                }
                case 4: {
                    if (Zone.hasBottomNeighbours(zone)) break;
                    int height2 = Zone.getHeight(view);
                    Zone.setHeight(view, height2 += dy);
                    break;
                }
                case 9: {
                    int x;
                    int y;
                    int height;
                    int height2;
                    int width;
                    if (!Zone.hasLeftNeighbours(zone) && !Zone.hasTopNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        height = Zone.getHeight(view);
                        Zone.setHeight(view, height += dy);
                        break;
                    }
                    if (!Zone.hasLeftNeighbours(zone) && Zone.hasTopNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        y = Zone.getY(view);
                        Zone.setY(view, y += dy);
                        break;
                    }
                    if (Zone.hasLeftNeighbours(zone) && !Zone.hasTopNeighbours(zone)) {
                        height2 = Zone.getHeight(view);
                        Zone.setHeight(view, height2 += dy);
                        x = Zone.getX(view);
                        Zone.setX(view, x += dx);
                        break;
                    }
                    int x2 = Zone.getX(view);
                    Zone.setX(view, x2 += dx);
                    y = Zone.getY(view);
                    Zone.setY(view, y += dy);
                    break;
                }
                case 17: {
                    int y;
                    int height;
                    int height2;
                    int width;
                    if (!Zone.hasRightNeighbours(zone) && !Zone.hasTopNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        height = Zone.getHeight(view);
                        Zone.setHeight(view, height += dy);
                        break;
                    }
                    if (!Zone.hasRightNeighbours(zone) && Zone.hasTopNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        y = Zone.getY(view);
                        Zone.setY(view, y += dy);
                        break;
                    }
                    if (Zone.hasRightNeighbours(zone) && !Zone.hasTopNeighbours(zone)) {
                        height2 = Zone.getHeight(view);
                        Zone.setHeight(view, height2 += dy);
                        break;
                    }
                    int y2 = Zone.getY(view);
                    Zone.setY(view, y2 += dy);
                    break;
                }
                case 12: {
                    int x;
                    int height;
                    int height2;
                    int width;
                    if (!Zone.hasLeftNeighbours(zone) && !Zone.hasBottomNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        height = Zone.getHeight(view);
                        Zone.setHeight(view, height += dy);
                        break;
                    }
                    if (!Zone.hasLeftNeighbours(zone) && Zone.hasBottomNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        break;
                    }
                    if (Zone.hasLeftNeighbours(zone) && !Zone.hasBottomNeighbours(zone)) {
                        height2 = Zone.getHeight(view);
                        Zone.setHeight(view, height2 += dy);
                        x = Zone.getX(view);
                        Zone.setX(view, x += dx);
                        break;
                    }
                    int x2 = Zone.getX(view);
                    Zone.setX(view, x2 += dx);
                    break;
                }
                case 20: {
                    int height;
                    int width;
                    if (!Zone.hasRightNeighbours(zone) && !Zone.hasBottomNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        height = Zone.getHeight(view);
                        Zone.setHeight(view, height += dy);
                        break;
                    }
                    if (!Zone.hasRightNeighbours(zone) && Zone.hasBottomNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        break;
                    }
                    if (!Zone.hasRightNeighbours(zone) || Zone.hasBottomNeighbours(zone)) continue block11;
                    int height2 = Zone.getHeight(view);
                    Zone.setHeight(view, height2 += dy);
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

