/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CompartmentFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.RoundedBorder;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.RoundedShadowBorder;

public class StateMachineFigure
extends CompartmentFigure {
    int arcwidth = 20;
    private static final String STATEMACHINE_COMPARTMENT = "stateMachineCompartment";
    private static final List<String> COMPARTMENT = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(StateMachineFigure.STATEMACHINE_COMPARTMENT);
        }
    };

    public StateMachineFigure() {
        this(null);
    }

    public StateMachineFigure(String tagLabel) {
        super(COMPARTMENT, tagLabel);
        this.shadowborder = new RoundedShadowBorder(this.getForegroundColor());
        this.setBorder((Border)this.shadowborder);
        ((AutomaticCompartmentLayoutManager)this.getLayoutManager()).setAddExtraHeight(false);
    }

    public RectangleFigure getStateMachineCompartmentFigure() {
        return this.getCompartment(STATEMACHINE_COMPARTMENT);
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        if (this.isUsingGradient()) {
            boolean isVertical;
            this.applyTransparency(graphics);
            boolean bl = isVertical = this.getGradientStyle() == 0;
            if (isVertical && rectangle.height > 3 * this.arcwidth / 2) {
                Rectangle rect1 = new Rectangle(rectangle.getLocation(), new Dimension(rectangle.width, this.arcwidth));
                Rectangle rect2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height - this.arcwidth, rectangle.width, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                graphics.fillRoundRectangle(rect1, this.arcwidth, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.fillRoundRectangle(rect2, this.arcwidth, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.setForegroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                Rectangle rect = new Rectangle(rectangle.x, rectangle.y + this.arcwidth / 2, rectangle.width, rectangle.height - this.arcwidth);
                graphics.fillGradient(rect, true);
            } else if (!isVertical && rectangle.width > 3 * this.arcwidth / 2) {
                Rectangle rect1 = new Rectangle(rectangle.getLocation(), new Dimension(this.arcwidth, rectangle.height));
                Rectangle rect2 = new Rectangle(rectangle.x + rectangle.width - this.arcwidth, rectangle.y, this.arcwidth, rectangle.height);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                graphics.fillRoundRectangle(rect1, this.arcwidth, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.fillRoundRectangle(rect2, this.arcwidth, this.arcwidth);
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.setForegroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                Rectangle rect = new Rectangle(rectangle.x + this.arcwidth / 2, rectangle.y, rectangle.width - this.arcwidth, rectangle.height);
                graphics.fillGradient(rect, false);
            } else {
                graphics.setBackgroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor1()));
                graphics.setForegroundColor(FigureUtilities.integerToColor((Integer)this.getGradientColor2()));
                graphics.fillRoundRectangle(rectangle, this.arcwidth, this.arcwidth);
            }
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.fillRoundRectangle(rectangle, this.arcwidth, this.arcwidth);
        }
    }

    public void paintFigure(Graphics graphics) {
        this.paintBackground(graphics, this.getBounds());
        this.shadowborder.setColor(this.getForegroundColor());
    }

    public void setShadow(boolean shadow) {
        super.setShadow(shadow);
        if (!shadow) {
            RoundedBorder bord = new RoundedBorder(this.arcwidth, this.arcwidth);
            this.setBorder((Border)bord);
        }
    }
}

