/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomRegionCreateElementCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.EMFCustomTransitionRetargetContainerCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.RegionFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;

public class CustomRegionCompartmentCreationEditPolicy
extends CreationEditPolicy {
    IFigure sizeOnDropFeedback = null;
    String dropLocation = "R";

    public void eraseTargetFeedback(Request request) {
        if (this.sizeOnDropFeedback != null) {
            LayerManager.Helper.find((EditPart)this.getHost()).getLayer((Object)"Feedback Layer").remove(this.sizeOnDropFeedback);
            this.sizeOnDropFeedback = null;
        }
    }

    protected org.eclipse.gef.commands.Command getReparentCommand(ChangeBoundsRequest changeBoundsRequest) {
        View container = (View)this.getHost().getAdapter(View.class);
        EObject context = container == null ? null : ViewUtil.resolveSemanticElement((View)container);
        CompositeCommand cc = new CompositeCommand("move (re-parent) state");
        for (EditPart ep : changeBoundsRequest.getEditParts()) {
            View view;
            if (ep instanceof LabelEditPart) continue;
            if (ep instanceof GroupEditPart) {
                cc.compose((IUndoableOperation)this.getReparentGroupCommand((GroupEditPart)ep));
            }
            if ((view = (View)ep.getAdapter(View.class)) == null) continue;
            EObject semantic = ViewUtil.resolveSemanticElement((View)view);
            if (semantic == null) {
                cc.compose((IUndoableOperation)this.getReparentViewCommand((IGraphicalEditPart)ep));
                continue;
            }
            if (context == null || !this.shouldReparent(semantic, context)) continue;
            cc.compose((IUndoableOperation)this.getReparentCommand((IGraphicalEditPart)ep));
            if (!(semantic instanceof State)) continue;
            State state = (State)semantic;
            for (Transition transition : state.getOutgoings()) {
                cc.compose((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)new EMFCustomTransitionRetargetContainerCommand(transition)));
            }
            for (Transition transition : state.getIncomings()) {
                cc.compose((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)new EMFCustomTransitionRetargetContainerCommand(transition)));
            }
        }
        return cc.isEmpty() ? null : new ICommandProxy(cc.reduce());
    }

    public org.eclipse.gef.commands.Command getCommand(Request request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        if (this.understandsRequest(request)) {
            if (request instanceof CreateUnspecifiedTypeRequest) {
                CreateUnspecifiedTypeRequest unspecReq = (CreateUnspecifiedTypeRequest)request;
                for (IElementType elementType : unspecReq.getElementTypes()) {
                    CreateRequest createRequest = unspecReq.getRequestForType(elementType);
                    if (!((IHintedType)elementType).getSemanticHint().equals(((IHintedType)UMLElementTypes.Region_3000).getSemanticHint())) continue;
                    View existingRegionCompartmentView = (View)this.getHost().getModel();
                    View existingRegionView = (View)existingRegionCompartmentView.eContainer();
                    SemanticAdapter adaptableForExistingRegionView = new SemanticAdapter(null, (Object)existingRegionView);
                    CustomRegionCreateElementCommand createNewRegion = new CustomRegionCreateElementCommand((IAdaptable)adaptableForExistingRegionView, null, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, this.dropLocation);
                    cc.compose((IUndoableOperation)createNewRegion);
                    return new ICommandProxy(cc.reduce());
                }
            } else if (request instanceof ChangeBoundsRequest) {
                return this.getReparentCommand((ChangeBoundsRequest)request);
            }
            return super.getCommand(request);
        }
        return null;
    }

    protected IFigure getSizeOnDropFeedback() {
        if (this.sizeOnDropFeedback == null) {
            this.sizeOnDropFeedback = new RectangleFigure();
            FigureUtilities.makeGhostShape((Shape)((Shape)this.sizeOnDropFeedback));
            ((Shape)this.sizeOnDropFeedback).setLineStyle(4);
            this.sizeOnDropFeedback.setForegroundColor(ColorConstants.white);
            LayerManager.Helper.find((EditPart)this.getHost()).getLayer((Object)"Feedback Layer").add(this.sizeOnDropFeedback);
        }
        return this.sizeOnDropFeedback;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            List elementTypes;
            CreateUnspecifiedTypeRequest createUnspecifiedTypeRequest = (CreateUnspecifiedTypeRequest)request;
            if (this.understandsRequest(request) && (elementTypes = createUnspecifiedTypeRequest.getElementTypes()).size() == 1 && ((IElementType)elementTypes.get(0) == UMLElementTypes.Pseudostate_16000 || (IElementType)elementTypes.get(0) == UMLElementTypes.Pseudostate_17000) && this.getHost() instanceof ShapeCompartmentEditPart) {
                return this.getHost().getParent().getParent().getParent();
            }
        }
        return super.getTargetEditPart(request);
    }

    public void showTargetFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            CreateUnspecifiedTypeRequest unspecReq = (CreateUnspecifiedTypeRequest)request;
            for (IElementType elementType : unspecReq.getElementTypes()) {
                if (!elementType.equals(UMLElementTypes.Region_3000)) continue;
                RegionFigure targetFig = ((RegionEditPart)this.getHost().getParent()).getPrimaryShape();
                Rectangle targetFigBounds = targetFig.getBounds().getCopy();
                targetFig.translateToAbsolute((Translatable)targetFigBounds);
                Point mouseLocation = unspecReq.getLocation();
                this.dropLocation = Zone.getZoneFromLocationInRectangleWithAbsoluteCoordinates(mouseLocation, targetFigBounds);
                if (Zone.isTop(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
                } else if (Zone.isLeft(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
                } else if (Zone.isRight(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(0.5, 1.0));
                    targetFigBounds.translate(targetFigBounds.width, 0);
                } else if (Zone.isBottom(this.dropLocation)) {
                    targetFigBounds.setSize(targetFigBounds.getSize().scale(1.0, 0.5));
                    targetFigBounds.translate(0, targetFigBounds.height);
                }
                this.getSizeOnDropFeedback().setBounds((Rectangle)new PrecisionRectangle(targetFigBounds));
            }
        }
    }
}

