/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.expressions.UMLOCLFactory;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.timing/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLTimingDiagram".equals(view.getType())) {
                return 1;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLTimingDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLTimingDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1: {
                if (!UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) break;
                return 2;
            }
            case 2: {
                if (!UMLPackage.eINSTANCE.getGate().isSuperTypeOf(domainElement.eClass())) break;
                return 69;
            }
            case 5: {
                if (UMLPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isLifeline_19(containerView, (Lifeline)domainElement)) {
                    return 19;
                }
                if (!UMLPackage.eINSTANCE.getLifeline().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isLifeline_20(containerView, (Lifeline)domainElement)) break;
                return 20;
            }
            case 8: {
                if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                    return 11;
                }
                if (UMLPackage.eINSTANCE.getOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 12;
                }
                if (UMLPackage.eINSTANCE.getMessageOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 13;
                }
                if (UMLPackage.eINSTANCE.getDestructionOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 27;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 18;
                }
                if (UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 17;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 15;
                }
                if (UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (!UMLPackage.eINSTANCE.getGeneralOrdering().isSuperTypeOf(domainElement.eClass())) break;
                return 67;
            }
            case 23: {
                if (UMLPackage.eINSTANCE.getStateInvariant().isSuperTypeOf(domainElement.eClass())) {
                    return 28;
                }
                if (UMLPackage.eINSTANCE.getOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 12;
                }
                if (UMLPackage.eINSTANCE.getMessageOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 13;
                }
                if (UMLPackage.eINSTANCE.getDestructionOccurrenceSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 27;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 18;
                }
                if (UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 17;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 15;
                }
                if (UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (!UMLPackage.eINSTANCE.getGeneralOrdering().isSuperTypeOf(domainElement.eClass())) break;
                return 67;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLTimingDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLTimingDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1: {
                if (2 != nodeVisualID) break;
                return true;
            }
            case 2: {
                if (37 == nodeVisualID) {
                    return true;
                }
                if (5 == nodeVisualID) {
                    return true;
                }
                if (29 == nodeVisualID) {
                    return true;
                }
                if (69 != nodeVisualID) break;
                return true;
            }
            case 19: {
                if (21 == nodeVisualID) {
                    return true;
                }
                if (7 == nodeVisualID) {
                    return true;
                }
                if (8 == nodeVisualID) {
                    return true;
                }
                if (82 != nodeVisualID) break;
                return true;
            }
            case 20: {
                if (22 == nodeVisualID) {
                    return true;
                }
                if (23 == nodeVisualID) {
                    return true;
                }
                if (83 != nodeVisualID) break;
                return true;
            }
            case 11: {
                if (62 != nodeVisualID) break;
                return true;
            }
            case 28: {
                if (31 == nodeVisualID) {
                    return true;
                }
                if (64 != nodeVisualID) break;
                return true;
            }
            case 12: {
                if (10 == nodeVisualID) {
                    return true;
                }
                if (58 != nodeVisualID) break;
                return true;
            }
            case 13: {
                if (14 == nodeVisualID) {
                    return true;
                }
                if (59 != nodeVisualID) break;
                return true;
            }
            case 9: {
                if (38 != nodeVisualID) break;
                return true;
            }
            case 15: {
                if (30 == nodeVisualID) {
                    return true;
                }
                if (65 != nodeVisualID) break;
                return true;
            }
            case 16: {
                if (34 == nodeVisualID) {
                    return true;
                }
                if (66 != nodeVisualID) break;
                return true;
            }
            case 18: {
                if (33 != nodeVisualID) break;
                return true;
            }
            case 17: {
                if (35 != nodeVisualID) break;
                return true;
            }
            case 67: {
                if (68 != nodeVisualID) break;
                return true;
            }
            case 24: {
                if (80 != nodeVisualID) break;
                return true;
            }
            case 25: {
                if (81 != nodeVisualID) break;
                return true;
            }
            case 26: {
                if (36 != nodeVisualID) break;
                return true;
            }
            case 27: {
                if (32 == nodeVisualID) {
                    return true;
                }
                if (63 != nodeVisualID) break;
                return true;
            }
            case 69: {
                if (70 != nodeVisualID) break;
                return true;
            }
            case 5: {
                if (19 == nodeVisualID) {
                    return true;
                }
                if (20 != nodeVisualID) break;
                return true;
            }
            case 7: {
                if (9 != nodeVisualID) break;
                return true;
            }
            case 8: {
                if (11 == nodeVisualID) {
                    return true;
                }
                if (12 == nodeVisualID) {
                    return true;
                }
                if (13 == nodeVisualID) {
                    return true;
                }
                if (27 == nodeVisualID) {
                    return true;
                }
                if (18 == nodeVisualID) {
                    return true;
                }
                if (17 == nodeVisualID) {
                    return true;
                }
                if (39 == nodeVisualID) {
                    return true;
                }
                if (15 == nodeVisualID) {
                    return true;
                }
                if (16 == nodeVisualID) {
                    return true;
                }
                if (67 != nodeVisualID) break;
                return true;
            }
            case 23: {
                if (28 == nodeVisualID) {
                    return true;
                }
                if (12 == nodeVisualID) {
                    return true;
                }
                if (13 == nodeVisualID) {
                    return true;
                }
                if (27 == nodeVisualID) {
                    return true;
                }
                if (18 == nodeVisualID) {
                    return true;
                }
                if (17 == nodeVisualID) {
                    return true;
                }
                if (15 == nodeVisualID) {
                    return true;
                }
                if (16 == nodeVisualID) {
                    return true;
                }
                if (67 != nodeVisualID) break;
                return true;
            }
            case 29: {
                if (24 == nodeVisualID) {
                    return true;
                }
                if (25 != nodeVisualID) break;
                return true;
            }
            case 82: {
                if (24 != nodeVisualID) break;
                return true;
            }
            case 83: {
                if (24 != nodeVisualID) break;
                return true;
            }
            case 80: {
                if (26 != nodeVisualID) break;
                return true;
            }
            case 81: {
                if (26 != nodeVisualID) break;
                return true;
            }
            case 3: {
                if (56 == nodeVisualID) {
                    return true;
                }
                if (57 != nodeVisualID) break;
                return true;
            }
            case 4: {
                if (60 == nodeVisualID) {
                    return true;
                }
                if (61 != nodeVisualID) break;
                return true;
            }
            case 41: {
                if (42 == nodeVisualID) {
                    return true;
                }
                if (43 != nodeVisualID) break;
                return true;
            }
            case 44: {
                if (45 == nodeVisualID) {
                    return true;
                }
                if (46 != nodeVisualID) break;
                return true;
            }
            case 47: {
                if (48 == nodeVisualID) {
                    return true;
                }
                if (49 != nodeVisualID) break;
                return true;
            }
            case 50: {
                if (51 == nodeVisualID) {
                    return true;
                }
                if (52 != nodeVisualID) break;
                return true;
            }
            case 53: {
                if (54 == nodeVisualID) {
                    return true;
                }
                if (55 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_3((Message)domainElement)) {
            return 3;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_4((Message)domainElement)) {
            return 4;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_41((Message)domainElement)) {
            return 41;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_44((Message)domainElement)) {
            return 44;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_47((Message)domainElement)) {
            return 47;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_50((Message)domainElement)) {
            return 50;
        }
        if (UMLPackage.eINSTANCE.getMessage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isMessage_53((Message)domainElement)) {
            return 53;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isLifeline_19(View containerView, Lifeline domainElement) {
        return LifelineUtils.getLifelineType(domainElement) == LifelineUtils.LifelineType.full;
    }

    private static boolean isLifeline_20(View containerView, Lifeline domainElement) {
        return LifelineUtils.getLifelineType(domainElement) == LifelineUtils.LifelineType.compact;
    }

    private static boolean isMessage_3(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(0, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_4(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(1, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_41(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_44(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(3, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_47(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(4, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_50(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(5, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isMessage_53(Message domainElement) {
        Object result = UMLOCLFactory.getExpression(6, (EClassifier)UMLPackage.eINSTANCE.getMessage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 5: 
            case 7: 
            case 8: 
            case 23: 
            case 29: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1: {
                return false;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 39: 
            case 40: 
            case 67: 
            case 69: {
                return true;
            }
        }
        return false;
    }
}

