/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.edit.policies;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.extendedtypes.util.ElementTypeUtils;
import org.eclipse.papyrus.uml.diagram.common.commands.DuplicateNamedElementCommand;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.ActorAsRectangleCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.ActorCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.CommentCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.ConstraintCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.DefaultNamedElementCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.PackageCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.ShapeNamedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.ShortCutDiagramCreateCommand;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.SubjectClassifierCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.UseCaseAsRectangleCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.UseCaseCreateCommandTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.usecase.providers.UMLElementTypes;

public class UseCaseDiagramItemSemanticEditPolicy
extends UMLBaseItemSemanticEditPolicy {
    public UseCaseDiagramItemSemanticEditPolicy() {
        super(UMLElementTypes.Package_1000);
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        IElementType requestElementType = req.getElementType();
        if (requestElementType == null) {
            return super.getCreateCommand(req);
        }
        IElementType baseElementType = requestElementType;
        boolean isExtendedType = false;
        if (requestElementType instanceof IExtendedHintedElementType) {
            baseElementType = ElementTypeUtils.getClosestDiagramType((IElementType)requestElementType);
            if (baseElementType != null) {
                isExtendedType = true;
            } else {
                baseElementType = ElementTypeUtils.findClosestNonExtendedElementType((IExtendedHintedElementType)((IExtendedHintedElementType)requestElementType));
                isExtendedType = true;
            }
        }
        if (UMLElementTypes.Actor_2011 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new ActorCreateCommandTN(req));
        }
        if (UMLElementTypes.Actor_2012 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new ActorAsRectangleCreateCommandTN(req));
        }
        if (UMLElementTypes.UseCase_2013 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new UseCaseCreateCommandTN(req));
        }
        if (UMLElementTypes.UseCase_2014 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new UseCaseAsRectangleCreateCommandTN(req));
        }
        if (UMLElementTypes.Classifier_2015 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new SubjectClassifierCreateCommandTN(req));
        }
        if (UMLElementTypes.Package_2016 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new PackageCreateCommandTN(req));
        }
        if (UMLElementTypes.Constraint_2017 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new ConstraintCreateCommandTN(req));
        }
        if (UMLElementTypes.Comment_2018 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new CommentCreateCommandTN(req));
        }
        if (UMLElementTypes.NamedElement_2022 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new DefaultNamedElementCreateCommandTN(req));
        }
        if (UMLElementTypes.NamedElement_2023 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new ShapeNamedElementCreateCommand(req));
        }
        if (UMLElementTypes.Diagram_2019 == baseElementType) {
            if (isExtendedType) {
                return this.getExtendedTypeCreationCommand(req, (IExtendedHintedElementType)requestElementType);
            }
            return this.getGEFWrapper((ICommand)new ShortCutDiagramCreateCommand(req));
        }
        return super.getCreateCommand(req);
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Diagram currentDiagram = null;
        if (this.getHost() instanceof IGraphicalEditPart) {
            currentDiagram = ((IGraphicalEditPart)this.getHost()).getNotationView().getDiagram();
        }
        return this.getGEFWrapper((ICommand)new DuplicateAnythingCommand(editingDomain, req, currentDiagram));
    }

    private static class DuplicateAnythingCommand
    extends DuplicateNamedElementCommand {
        private Diagram diagram;

        public DuplicateAnythingCommand(TransactionalEditingDomain editingDomain, DuplicateElementsRequest req, Diagram currentDiagram) {
            super(editingDomain, req.getLabel(), req.getElementsToBeDuplicated(), req.getAllDuplicatedElementsMap(), currentDiagram);
            this.diagram = currentDiagram;
        }
    }
}

