/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.handler;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.ui.SwitchProfileDialog;
import org.eclipse.papyrus.uml.tools.util.ProfileHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class SwitchProfileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection.isEmpty() || !(currentSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        Object selectedElement = selection.getFirstElement();
        Object selectedAdapter = Platform.getAdapterManager().getAdapter(selectedElement, IFile.class);
        final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (selectedAdapter instanceof IFile) {
            final IFile selectedFile = (IFile)selectedAdapter;
            Job openDialogJob = new Job("Switch profile"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Analyzing model...", -1);
                    DiResourceSet modelSet = new DiResourceSet();
                    TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)modelSet);
                    IPath workspacePath = selectedFile.getFullPath();
                    URI workspaceURI = URI.createPlatformResourceURI((String)workspacePath.toString(), (boolean)true);
                    try {
                        modelSet.loadModels(workspaceURI);
                        SwitchProfileHandler.this.switchProfilesForModelSet((ModelSet)modelSet, editingDomain, activeShell);
                    }
                    catch (ModelMultiException e) {
                        Activator.log.error((Throwable)e);
                        return new Status(4, "org.eclipse.papyrus.uml.modelrepair", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            openDialogJob.setUser(true);
            openDialogJob.schedule();
        }
        return null;
    }

    public void switchProfilesForModelSet(final ModelSet modelSet, final TransactionalEditingDomain editingDomain, final Shell activeShell) {
        EcoreUtil.resolveAll((ResourceSet)modelSet);
        final Collection allAppliedProfiles = ProfileHelper.getAllAppliedProfiles((ModelSet)modelSet);
        activeShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (allAppliedProfiles.isEmpty()) {
                    MessageDialog.openInformation((Shell)activeShell, (String)"This model isn't profiled", (String)"The selected model doesn't have any applied profile");
                    return;
                }
                SwitchProfileDialog dialog = new SwitchProfileDialog(activeShell, modelSet, editingDomain);
                dialog.open();
                modelSet.unload();
            }
        });
    }
}

