/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.resource.DependencyManagementHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.tools.util.ProfileHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.uml2.uml.Profile;

public class SwitchProfileDialog
extends SelectionDialog {
    private static final int APPLY_ID = 1025;
    private static final String APPLY_LABEL = "Apply";
    private static final int BROWSE_WORKSPACE_ID = 1026;
    private static final int BROWSE_REGISTERED_ID = 1027;
    private ModelSet modelSet;
    private TransactionalEditingDomain editingDomain;
    protected TableViewer viewer;
    protected Table table;
    protected LabelProviderService labelProviderService;
    protected final Map<Resource, Resource> profilesToEdit = new HashMap<Resource, Resource>();

    public SwitchProfileDialog(Shell shell, ModelSet modelSet, TransactionalEditingDomain domain) {
        super(shell);
        this.modelSet = modelSet;
        this.editingDomain = domain;
        this.labelProviderService = new LabelProviderServiceImpl();
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Composite self = new Composite(contents, 0);
        self.setLayout((Layout)new GridLayout(1, false));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        Label descriptionLabel = new Label(self, 64);
        String description = "Select an applied profile, then select a profile (either from the workspace, or a registered one)\n";
        description = String.valueOf(description) + "If the profiles are equivalent, the selected profile will replace the applied profile. Stereotype applications will be kept\n";
        description = String.valueOf(description) + "Two profiles are equivalent if, e.g. one is the copy of the other, or if you have deployed a workspace profile in a plug-in\n";
        description = String.valueOf(description) + "If a profile P' is a copy of a profile P, with some modifications, they are also equivalent";
        descriptionLabel.setText(description);
        descriptionLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Label warningLabel = new Label(self, 64);
        String warning = "/!\\ Replacing an applied profile with a totally different one will result in an invalid model /!\\";
        warningLabel.setText(warning);
        warningLabel.setForeground(parent.getDisplay().getSystemColor(4));
        warningLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite buttonsBarComposite = new Composite(self, 0);
        GridLayout buttonsLayout = new GridLayout(0, false);
        buttonsLayout.marginWidth = 0;
        buttonsBarComposite.setLayout((Layout)buttonsLayout);
        buttonsBarComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Button browseWorkspace = this.createButton(buttonsBarComposite, 1026, "", false);
        browseWorkspace.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/Add_12x12.gif"));
        Button browseRegistered = this.createButton(buttonsBarComposite, 1027, "", false);
        browseRegistered.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.uml.modelrepair", "icons/AddReg.gif"));
        this.viewer = new TableViewer(self, 67584);
        this.table = this.viewer.getTable();
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.table, 0);
        nameColumn.setText("Applied profile");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 150, true));
        TableColumn locationColumn = new TableColumn(this.table, 0);
        locationColumn.setText("Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 500, true));
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ModelSet) {
                    ModelSet modelSet = (ModelSet)inputElement;
                    Collection allAppliedProfiles = ProfileHelper.getAllAppliedProfiles((ModelSet)modelSet);
                    HashSet<Resource> allResources = new HashSet<Resource>();
                    for (Profile appliedProfile : allAppliedProfiles) {
                        URI profileResourceURI = EcoreUtil.getURI((EObject)appliedProfile).trimFragment();
                        Resource resource = modelSet.getResource(profileResourceURI, true);
                        allResources.add(resource);
                    }
                    return allResources.toArray();
                }
                return null;
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProfileColumnsLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Resource) {
                    Resource resource = (Resource)element;
                    for (EObject rootElement : resource.getContents()) {
                        if (!(rootElement instanceof Profile)) continue;
                        return ((Profile)rootElement).getName();
                    }
                    return resource.getURI().toString();
                }
                return super.getText(element);
            }
        }));
        this.viewer.setInput((Object)this.modelSet);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SwitchProfileDialog.this.updateControls();
            }
        });
        return contents;
    }

    protected void updateControls() {
        this.getButton(1025).setEnabled(!this.profilesToEdit.isEmpty());
        boolean enableBrowse = !this.viewer.getSelection().isEmpty();
        this.getButton(1027).setEnabled(enableBrowse);
        this.getButton(1026).setEnabled(enableBrowse);
    }

    protected void setButtonLayoutData(Button button) {
        int buttonId = (Integer)button.getData();
        if (buttonId == 1027 || buttonId == 1026) {
            return;
        }
        super.setButtonLayoutData(button);
    }

    protected void applyPressed() {
        if (this.profilesToEdit.isEmpty()) {
            return;
        }
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain, "Edit profile applications"){

            protected void doExecute() {
                LinkedList allReplacements = new LinkedList();
                for (Map.Entry<Resource, Resource> replacementEntry : SwitchProfileDialog.this.profilesToEdit.entrySet()) {
                    URI targetURI;
                    URI uriToReplace = replacementEntry.getKey().getURI();
                    if (uriToReplace.equals(targetURI = replacementEntry.getValue().getURI())) continue;
                    Collection result = DependencyManagementHelper.updateDependencies((URI)uriToReplace, (URI)targetURI, (ResourceSet)SwitchProfileDialog.this.modelSet, (EditingDomain)SwitchProfileDialog.this.editingDomain);
                    allReplacements.addAll(result);
                }
                if (allReplacements.isEmpty()) {
                    MessageDialog.openWarning((Shell)SwitchProfileDialog.this.getShell(), (String)"Nothing changed", (String)"Nothing to change");
                }
            }
        });
        this.profilesToEdit.clear();
        this.updateControls();
        this.viewer.refresh();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, APPLY_LABEL, true);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.applyPressed();
                return;
            }
            case 1027: {
                this.browseRegisteredProfiles();
                return;
            }
            case 1026: {
                this.browseWorkspaceProfiles();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        this.updateControls();
        this.getShell().setText("Switch profile location");
        this.getShell().setMinimumSize(600, 400);
        this.getShell().pack();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void okPressed() {
        this.applyPressed();
        try {
            this.modelSet.save((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
        super.okPressed();
    }

    public boolean close() {
        this.profilesToEdit.clear();
        try {
            this.labelProviderService.disposeService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        return super.close();
    }

    protected void browseWorkspaceProfiles() {
        if (this.getSelectedResource() == null) {
            return;
        }
        LinkedHashMap<String, String> extensionFilters = new LinkedHashMap<String, String>();
        extensionFilters.put("*.profile.uml", "UML Profiles (*.profile.uml)");
        extensionFilters.put("*.uml", "UML (*.uml)");
        extensionFilters.put("*", "All (*)");
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        WorkspaceContentProvider workspaceContentProvider = new WorkspaceContentProvider();
        workspaceContentProvider.setExtensionFilters(extensionFilters);
        dialog.setContentProvider((ITreeContentProvider)workspaceContentProvider);
        dialog.setLabelProvider(this.labelProviderService.getLabelProvider());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedFile = result[0];
            if (selectedFile instanceof IFile) {
                IPath filePath = ((IFile)selectedFile).getFullPath();
                URI workspaceURI = URI.createPlatformResourceURI((String)filePath.toString(), (boolean)true);
                this.replaceSelectionWith(workspaceURI);
            }
        }
    }

    protected Resource getSelectedResource() {
        Object selectedElement;
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Resource) {
            return (Resource)selectedElement;
        }
        return null;
    }

    protected void browseRegisteredProfiles() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)new StaticContentProvider((Object[])RegisteredProfile.getRegisteredProfiles())));
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof RegisteredProfile) {
                    RegisteredProfile profile = (RegisteredProfile)element;
                    return profile.getImage();
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof RegisteredProfile) {
                    RegisteredProfile profile = (RegisteredProfile)element;
                    return profile.name;
                }
                return super.getText(element);
            }
        });
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return;
            }
            Object selectedElement = result[0];
            if (selectedElement instanceof RegisteredProfile) {
                RegisteredProfile profile = (RegisteredProfile)selectedElement;
                this.replaceSelectionWith(profile.uri);
            }
        }
    }

    protected void replaceSelectionWith(URI targetURI) {
        Resource targetResource = this.modelSet.getResource(targetURI, true);
        if (this.getSelectedResource() != targetResource) {
            this.profilesToEdit.put(this.getSelectedResource(), targetResource);
            this.updateControls();
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Nothing changed", (String)"Nothing to change");
        }
    }

    private class ProfileColumnsLabelProvider
    extends ColumnLabelProvider {
        private ILabelProvider defaultLabelProvider;

        public ProfileColumnsLabelProvider(ILabelProvider defaultLabelProvider) {
            this.defaultLabelProvider = defaultLabelProvider;
        }

        public void update(ViewerCell cell) {
            if (cell.getColumnIndex() == 0) {
                this.updateName(cell);
                return;
            }
            Object element = cell.getElement();
            if (!(element instanceof Resource)) {
                cell.setText("");
                return;
            }
            Resource resource = (Resource)element;
            if (cell.getColumnIndex() == 1) {
                this.updateLocation(cell, resource);
            }
        }

        public void updateName(ViewerCell cell) {
            cell.setImage(this.defaultLabelProvider.getImage(cell.getElement()));
            cell.setText(this.defaultLabelProvider.getText(cell.getElement()));
        }

        public void updateLocation(ViewerCell cell, Resource resource) {
            URI uri;
            String location = "Unknown";
            if (resource != null && (uri = resource.getURI()) != null) {
                location = uri.toString();
            }
            cell.setText(location);
        }
    }
}

