/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui.providers;

import com.google.common.base.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.swt.graphics.Image;

public class ResourceLabelProvider
extends ColumnLabelProvider {
    protected ResourceSet resourceSet;

    public ResourceLabelProvider(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public void update(ViewerCell cell) {
        switch (cell.getColumnIndex()) {
            case 0: {
                this.updateResource(cell);
                break;
            }
            case 1: {
                this.updateLocation(cell);
                break;
            }
            case 2: {
                this.updateReadOnly(cell);
            }
        }
    }

    protected void updateResource(ViewerCell cell) {
        cell.setText(this.getResourceText(cell.getElement()));
        cell.setImage(this.getResourceImage(cell.getElement()));
    }

    protected void updateLocation(ViewerCell cell) {
        cell.setText(this.getLocationText(cell.getElement()));
    }

    private String getLocationText(Object element) {
        URI uri = this.getURI(element);
        if (uri != null) {
            return uri.toString();
        }
        return "Unknown";
    }

    protected void updateReadOnly(ViewerCell cell) {
        cell.setText(this.getReadOnlyText(cell.getElement()));
    }

    private String getReadOnlyText(Object element) {
        URI uri = this.getURI(element);
        if (uri == null) {
            return "?";
        }
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(this.resourceSet);
        Optional readOnly = ReadOnlyManager.getReadOnlyHandler((EditingDomain)domain).anyReadOnly(new URI[]{uri});
        if (readOnly.isPresent()) {
            return (Boolean)readOnly.get() != false ? "true" : "false";
        }
        return "false";
    }

    public String getResourceText(Object element) {
        URI uri = this.getURI(element);
        if (uri == null) {
            return null;
        }
        return uri.lastSegment();
    }

    protected URI getURI(Object element) {
        if (element instanceof URI) {
            return (URI)element;
        }
        if (element instanceof Resource) {
            return ((Resource)element).getURI();
        }
        return null;
    }

    public Image getResourceImage(Object element) {
        URI uri = this.getURI(element);
        if (uri == null) {
            return null;
        }
        String extension = uri.fileExtension();
        "uml".equals(extension);
        "di".equals(extension);
        "notation".equals(extension);
        return null;
    }

    public String getText(Object element) {
        URI uri = this.getURI(element);
        if (uri != null) {
            return this.getURI(element).toString();
        }
        return super.getText(element);
    }
}

