/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.instance.util.TableContentsUtils;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.utils.AdditionalContentsUtils;
import org.eclipse.papyrus.uml.profilefacet.utils.ModelQuerySetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfileFacetSetMoveHelper {
    private ProfileFacetSetMoveHelper() {
    }

    public static ICommand getMoveAllFacetSetsCommand(TransactionalEditingDomain domain, EObject selection, Resource source, final Resource target) {
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(domain, "Move facet sets");
        Collection pTables = TableContentsUtils.getPapyrusTableInstances((EObject)selection);
        if (!pTables.isEmpty()) {
            HashSet facetsUsed = new HashSet();
            for (PapyrusTableInstance papyrusTableInstance : pTables) {
                facetsUsed.addAll(papyrusTableInstance.getTable().getFacets2());
            }
            HashSet<FacetSet> facetsets = new HashSet<FacetSet>();
            for (Facet facet : facetsUsed) {
                FacetSet facetset = ProfileFacetSetMoveHelper.getRootFacetSet(facet);
                if (facetset.eResource() != source) continue;
                facetsets.add(facetset);
            }
            if (!facetsets.isEmpty()) {
                boolean moveAdditionalFacetSet;
                EPackage additionalEPackageSource = AdditionalContentsUtils.getAdditionalContentsEPackage(source);
                EPackage additionalEPackageTarget = AdditionalContentsUtils.getAdditionalContentsEPackage(target);
                boolean bl = moveAdditionalFacetSet = facetsets.size() != 0;
                if (!(additionalEPackageSource == null && additionalEPackageTarget == null || additionalEPackageSource == null && additionalEPackageTarget != null || additionalEPackageSource == null || !moveAdditionalFacetSet)) {
                    if (additionalEPackageTarget != null) {
                        ICommand tmp = ProfileFacetSetMoveHelper.getMergeAdditionalContentsEPackageCommand(domain, (XMIResource)source, (XMIResource)target, pTables, facetsets, facetsets, additionalEPackageSource, additionalEPackageTarget);
                        if (tmp != null) {
                            cc.add((IUndoableOperation)tmp);
                        }
                    } else {
                        EcoreUtil.Copier copier = new EcoreUtil.Copier();
                        final EPackage copy = (EPackage)copier.copy((EObject)additionalEPackageSource);
                        copy.getEClassifiers().clear();
                        copy.getESubpackages().clear();
                        Collection duplicatedFacetSets = copier.copyAll(facetsets);
                        copy.getESubpackages().addAll(duplicatedFacetSets);
                        HashSet<ModelQuerySet> sets = new HashSet<ModelQuerySet>();
                        for (FacetSet current : facetsets) {
                            ModelQuerySet tmp = ModelQuerySetUtil.getModelQuerySet((EObject)current);
                            if (tmp == null) continue;
                            sets.add(tmp);
                        }
                        final Collection duplicatedQuerySet = copier.copyAll(sets);
                        copier.copyReferences();
                        AbstractTransactionalCommand addToResource = new AbstractTransactionalCommand(domain, "Add the copy of the Additional Content EPackage to the resource", null){

                            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                target.getContents().add((Object)copy);
                                target.getContents().addAll(duplicatedQuerySet);
                                return CommandResult.newOKCommandResult();
                            }
                        };
                        cc.add((IUndoableOperation)addToResource);
                        ICommand tmp2 = ProfileFacetSetMoveHelper.getUpdateFacetElementReferencesCommand(domain, pTables, (Map<EObject, EObject>)copier);
                        if (tmp2 != null) {
                            cc.add((IUndoableOperation)tmp2);
                        }
                        cc.add((IUndoableOperation)ProfileFacetSetMoveHelper.getCopyXMI_IDCommand(domain, (Map<EObject, EObject>)copier));
                    }
                }
            }
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private static ICommand getMergeAdditionalContentsEPackageCommand(TransactionalEditingDomain domain, XMIResource sourceResource, final XMIResource targetResource, Collection<PapyrusTableInstance> tables, Collection<FacetSet> sourceFacetSets, Collection<FacetSet> targetFacetSets, EPackage source, final EPackage target) {
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(domain, "Merge additional epackage contents");
        HashMap<ModelQuerySet, ModelQuerySet> sourceVSTargetModelQuerySet = new HashMap<ModelQuerySet, ModelQuerySet>();
        HashMap<String, FacetSet> sourceMap = new HashMap<String, FacetSet>();
        for (FacetSet current : sourceFacetSets) {
            String XMI_ID = sourceResource.getID((EObject)current);
            sourceMap.put(XMI_ID, current);
        }
        HashMap<String, FacetSet> targeteMap = new HashMap<String, FacetSet>();
        for (FacetSet current : targetFacetSets) {
            String XMI_ID = targetResource.getID((EObject)current);
            targeteMap.put(XMI_ID, current);
        }
        for (String XMI_ID : sourceMap.keySet()) {
            FacetSet sourceFacetSet = (FacetSet)sourceMap.get(XMI_ID);
            FacetSet targetFacetSet = (FacetSet)targeteMap.get(XMI_ID);
            if (targetFacetSet != null) continue;
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            final FacetSet copy = (FacetSet)copier.copy((EObject)sourceFacetSet);
            ModelQuerySet modelQuerySet = ModelQuerySetUtil.getModelQuerySet((EObject)sourceFacetSet);
            if (!sourceVSTargetModelQuerySet.containsKey(modelQuerySet)) {
                final ModelQuerySet duplicatedQuerySet = (ModelQuerySet)copier.copy((EObject)modelQuerySet);
                sourceVSTargetModelQuerySet.put(modelQuerySet, duplicatedQuerySet);
                AbstractTransactionalCommand addModelQuerySetToResource = new AbstractTransactionalCommand(domain, null, null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        targetResource.getContents().add((Object)duplicatedQuerySet);
                        return CommandResult.newOKCommandResult();
                    }
                };
                cc.add((IUndoableOperation)addModelQuerySetToResource);
            }
            copier.copyReferences();
            targeteMap.put(XMI_ID, copy);
            AbstractTransactionalCommand addFacetSetToAdditionalContentsFacetSet = new AbstractTransactionalCommand(domain, null, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    target.getESubpackages().add((Object)copy);
                    return CommandResult.newOKCommandResult();
                }
            };
            cc.add((IUndoableOperation)addFacetSetToAdditionalContentsFacetSet);
            cc.add((IUndoableOperation)ProfileFacetSetMoveHelper.getCopyXMI_IDCommand(domain, (Map<EObject, EObject>)copier));
            ICommand tmp = ProfileFacetSetMoveHelper.getUpdateFacetElementReferencesCommand(domain, tables, (Map<EObject, EObject>)copier);
            if (tmp == null) continue;
            cc.add((IUndoableOperation)tmp);
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    public static final FacetSet getRootFacetSet(Facet facet) {
        FacetSet set = (FacetSet)facet.eContainer();
        while (set.eContainer() != null && set.eContainer() instanceof FacetSet) {
            set = (FacetSet)set.eContainer();
        }
        return set;
    }

    private static ICommand getCopyXMI_IDCommand(TransactionalEditingDomain domain, final Map<EObject, EObject> map) {
        return new AbstractTransactionalCommand(domain, "Copy XMI_ID Command", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                for (EObject sourceValue : map.keySet()) {
                    EObject targetValue = (EObject)map.get(sourceValue);
                    Assert.isNotNull((Object)targetValue);
                    XMIResource sourceRes = (XMIResource)sourceValue.eResource();
                    XMIResource targetRes = (XMIResource)targetValue.eResource();
                    if (!$assertionsDisabled && sourceRes == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && targetRes == null) {
                        throw new AssertionError();
                    }
                    String XMI_ID = sourceRes.getID(sourceValue);
                    targetRes.setID(targetValue, XMI_ID);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private static ICommand getUpdateFacetElementReferencesCommand(TransactionalEditingDomain domain, Collection<PapyrusTableInstance> papyrusTables, Map<EObject, EObject> sourceToTarget) {
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(domain, "Update References To facet Element Command");
        ArrayList<TableInstance2> tableInstances = new ArrayList<TableInstance2>();
        for (PapyrusTableInstance pTable : papyrusTables) {
            tableInstances.add(pTable.getTable());
        }
        for (PapyrusTableInstance pTable : papyrusTables) {
            for (final EObject eobjectSource : sourceToTarget.keySet()) {
                EObject eobject;
                ECrossReferenceAdapter adapter;
                final EObject eobjectTarget = sourceToTarget.get(eobjectSource);
                if (eobjectSource instanceof StereotypePropertyElement) {
                    adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eobjectSource);
                    for (final EStructuralFeature.Setting setting : adapter.getNonNavigableInverseReferences(eobjectSource)) {
                        TableInstance t;
                        eobject = setting.getEObject();
                        if (!(eobject instanceof FacetAttributeColumn) && !(eobject instanceof FacetReferenceColumn) || !tableInstances.contains(t = (TableInstance)eobject.eContainer())) continue;
                        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, null, null){

                            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)eobjectSource, (Object)eobjectTarget);
                                return CommandResult.newOKCommandResult();
                            }
                        };
                        cc.add((IUndoableOperation)cmd);
                    }
                    continue;
                }
                if (!(eobjectSource instanceof Facet)) continue;
                adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eobjectSource);
                for (final EStructuralFeature.Setting setting : adapter.getNonNavigableInverseReferences(eobjectSource)) {
                    eobject = setting.getEObject();
                    if (!(eobject instanceof TableInstance2) || !tableInstances.contains(eobject)) continue;
                    AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, null, null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)eobjectSource, (Object)eobjectTarget);
                            return CommandResult.newOKCommandResult();
                        }
                    };
                    cc.add((IUndoableOperation)cmd);
                }
            }
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private static Map<EObject, EObject> createMappingBetweenFacetSets(EPackage source, EPackage target) {
        Map<String, EObject> sourceMap = ProfileFacetSetMoveHelper.createXMI_ID_MapForFacetSetContents(source);
        Map<String, EObject> targetMap = ProfileFacetSetMoveHelper.createXMI_ID_MapForFacetSetContents(target);
        HashMap<EObject, EObject> mapping = new HashMap<EObject, EObject>();
        for (String xmi_id : sourceMap.keySet()) {
            EObject key = sourceMap.get(xmi_id);
            EObject value = targetMap.get(xmi_id);
            if (value == null) continue;
            mapping.put(key, value);
        }
        return mapping;
    }

    private static Map<String, FacetSet> createXMI_ID_Map_ForFirstFacetSets(EPackage set) {
        HashMap<String, FacetSet> map = new HashMap<String, FacetSet>();
        XMIResource sourceRes = (XMIResource)set.eResource();
        for (EPackage current : set.getESubpackages()) {
            if (!(current instanceof FacetSet)) continue;
            String XMI_ID = sourceRes.getID((EObject)current);
            map.put(XMI_ID, (FacetSet)current);
        }
        return map;
    }

    private static Map<String, EObject> createXMI_ID_MapForFacetSetContents(EPackage set) {
        HashMap<String, EObject> map = new HashMap<String, EObject>();
        XMIResource resource = (XMIResource)set.eResource();
        TreeIterator iter = set.eAllContents();
        while (iter.hasNext()) {
            EObject key = (EObject)iter.next();
            String XMI_ID = resource.getID(key);
            map.put(XMI_ID, key);
        }
        return map;
    }
}

