/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.datatype.DataTypeProvider;
import org.eclipse.papyrus.uml.properties.datatype.StructuredDataTypeObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableList;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.views.properties.modelelement.EMFModelElement;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeModelElement
extends EMFModelElement {
    protected Stereotype stereotype;

    public StereotypeModelElement(EObject stereotypeApplication, Stereotype stereotype, EditingDomain domain) {
        super(stereotypeApplication, domain);
        this.stereotype = stereotype;
    }

    public IObservable doGetObservable(String propertyPath) {
        FeaturePath featurePath = this.getFeaturePath(propertyPath);
        EStructuralFeature feature = this.getFeature(featurePath);
        if (feature.getEType() instanceof EDataType && !(feature.getEType() instanceof EEnum) && feature.getUpperBound() == 1 && DataTypeProvider.instance.canHandle((EDataType)feature.getEType())) {
            return new StructuredDataTypeObservableValue(this.source, feature, this.domain, (EDataType)feature.getEType());
        }
        if (feature.getUpperBound() != 1) {
            return new PapyrusObservableList((List)EMFProperties.list((FeaturePath)featurePath).observe((Object)this.source), this.domain, this.getSource(featurePath), feature);
        }
        return new PapyrusObservableValue(this.getSource(featurePath), feature, this.domain);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (feature.getEType() instanceof EEnum) {
            return super.getLabelProvider(propertyPath);
        }
        return new UMLFilteredLabelProvider();
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        EStructuralFeature feature = this.getFeature(propertyPath);
        return new UMLContentProvider(this.source, feature, this.stereotype);
    }
}

