/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.uml.tools.utils.Activator;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementUtil {
    @Deprecated
    public static EObject hasStereotype(Element elt, EClass stereotypeClass) {
        return UMLUtil.getStereotypeApplication((Element)elt, stereotypeClass.getClass());
    }

    @Deprecated
    public static <T extends EObject> T getStereotypeApplication(Element element, java.lang.Class<T> clazz) {
        return (T)UMLUtil.getStereotypeApplication((Element)element, clazz);
    }

    public static Image getStereotypeImage(Element element, Stereotype stereotype, String kind) {
        if (stereotype == null || element.getAppliedStereotypes() == null) {
            return null;
        }
        Image image = null;
        image = ElementUtil.getStereotypeImageFromGetter(element, stereotype, kind);
        if (image == null) {
            EList<Image> availableImages = new EList<Image>();
            if ("icon".equals(kind)) {
                availableImages = StereotypeUtil.getIcons(stereotype);
            } else if ("shape".equals(kind)) {
                availableImages = StereotypeUtil.getShapes(stereotype);
            }
            if (!availableImages.isEmpty() && (image = ImageUtil.findImageVerifyingExpression(element, availableImages)) == null) {
                image = (Image)availableImages.get(0);
            }
        }
        return image;
    }

    public static Image getStereotypeImage(Element element, String kind) {
        if (element.getAppliedStereotypes() == null || element.getAppliedStereotypes().isEmpty()) {
            return null;
        }
        Stereotype stereotype = (Stereotype)element.getAppliedStereotypes().get(0);
        return ElementUtil.getStereotypeImage(element, stereotype, kind);
    }

    public static Image getStereotypeImageFromGetter(Element element, Stereotype stereotype, String kind) {
        String getterName = "";
        if ("icon".equals(kind)) {
            getterName = String.valueOf(getterName) + "getIcon";
        } else if ("shape".equals(kind)) {
            getterName = String.valueOf(getterName) + "getShape";
        } else {
            return null;
        }
        EObject stApp = element.getStereotypeApplication(stereotype);
        Method getter = null;
        try {
            getter = stApp.getClass().getDeclaredMethod(getterName, new java.lang.Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (getter != null) {
            try {
                Image image = (Image)getter.invoke((Object)stApp, new Object[0]);
                return image;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static boolean hasIcons(Element element) {
        if (!element.getAppliedStereotypes().isEmpty()) {
            return ElementUtil.hasIcons(element, (Stereotype)element.getAppliedStereotypes().get(0));
        }
        return false;
    }

    public static boolean hasIcons(Element element, Stereotype stereotype) {
        return stereotype != null && !StereotypeUtil.getIcons(stereotype).isEmpty();
    }

    public static boolean hasShapes(Element element) {
        if (!element.getAppliedStereotypes().isEmpty()) {
            return ElementUtil.hasShapes(element, (Stereotype)element.getAppliedStereotypes().get(0));
        }
        return false;
    }

    public static boolean hasShapes(Element element, Stereotype stereotype) {
        return stereotype != null && !StereotypeUtil.getShapes(stereotype).isEmpty();
    }

    public static List<Class> getPossibleMetaclasses(Element element) {
        ArrayList<Class> metaList = new ArrayList<Class>();
        List<Type> metaclasses = ElementUtil.getMetaclasses(element);
        int i = 0;
        while (i < metaclasses.size()) {
            if (metaclasses.get(i) instanceof Class) {
                metaList.add((Class)metaclasses.get(i));
            }
            ++i;
        }
        return metaList;
    }

    public static List<Type> getMetaclasses(Element element) {
        if (element == null) {
            System.err.println("element should not be null to retrieve metaclasses");
        }
        Package uml2Metamodel = ElementUtil.contentload(URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), element);
        return uml2Metamodel.getOwnedTypes();
    }

    public static Package contentload(URI uri, Element element) {
        ResourceSet resourceSet = element.eResource().getResourceSet();
        Package package_ = null;
        try {
            Resource resource = resourceSet.getResource(uri, true);
            package_ = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
        }
        catch (WrappedException we) {
            Activator.logError("impossible to load content for URI: " + uri);
        }
        return package_;
    }

    public static final <T extends EObject> List<T> getInstancesFilteredByType(Package topPackage, java.lang.Class<T> metaType, Stereotype appliedStereotype) {
        TreeIterator iter = topPackage.eAllContents();
        ArrayList<EObject> filteredElements = new ArrayList<EObject>();
        while (iter.hasNext()) {
            EObject currentElt = (EObject)iter.next();
            if (currentElt instanceof ElementImport) {
                ElementImport elementImport = (ElementImport)currentElt;
                currentElt = elementImport.getImportedElement();
            } else if (currentElt instanceof PackageImport) {
                TreeIterator piIter = ((PackageImport)currentElt).getImportedPackage().eAllContents();
                while (piIter.hasNext()) {
                    EObject piCurrentElt = (EObject)piIter.next();
                    if (!(piCurrentElt instanceof Element)) continue;
                    if (appliedStereotype != null) {
                        for (Stereotype currentSt : ((Element)piCurrentElt).getAppliedStereotypes()) {
                            if (!currentSt.conformsTo((Classifier)appliedStereotype)) continue;
                            filteredElements.add(piCurrentElt);
                        }
                        continue;
                    }
                    if (metaType.isInstance(piCurrentElt)) {
                        filteredElements.add(piCurrentElt);
                        continue;
                    }
                    if (!(piCurrentElt instanceof ElementImport)) continue;
                    TreeIterator eIter = ((ElementImport)piCurrentElt).getImportedElement().eAllContents();
                    while (eIter.hasNext()) {
                        EObject currentEIelt = (EObject)eIter.next();
                        if (!metaType.isInstance(currentEIelt)) continue;
                        filteredElements.add(currentEIelt);
                    }
                }
            }
            if (!(currentElt instanceof Element)) continue;
            if (appliedStereotype != null) {
                for (Stereotype currentSt : ((Element)currentElt).getAppliedStereotypes()) {
                    if (!currentSt.conformsTo((Classifier)appliedStereotype)) continue;
                    filteredElements.add(currentElt);
                }
                continue;
            }
            if (metaType.isInstance(currentElt)) {
                filteredElements.add(currentElt);
                continue;
            }
            if (!(currentElt instanceof ElementImport)) continue;
            TreeIterator eIter = ((ElementImport)currentElt).getImportedElement().eAllContents();
            while (eIter.hasNext()) {
                EObject currentEIelt = (EObject)eIter.next();
                if (!metaType.isInstance(currentEIelt)) continue;
                filteredElements.add(currentEIelt);
            }
        }
        return filteredElements;
    }
}

