/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.PropertyUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class PortUtil
extends PropertyUtil {
    public static String getCustomLabel(Property property, int style) {
        boolean multiLine;
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)property));
        }
        if ((style & 4) != 0 && property.isDerived()) {
            buffer.append("/");
        }
        if ((style & 8) != 0) {
            buffer.append(" ");
            buffer.append(property.getName());
        }
        if ((style & 0x10) != 0) {
            if ((style & 0x80000) != 0) {
                if (((Port)property).isConjugated()) {
                    buffer.append(": ~");
                } else {
                    buffer.append(": ");
                }
            } else {
                buffer.append(": ");
            }
            if (property.getType() != null) {
                buffer.append(property.getType().getName());
            } else {
                buffer.append("<Undefined>");
            }
        }
        if ((style & 0x20) != 0) {
            String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property);
            buffer.append(multiplicity);
        }
        if ((style & 0x40) != 0 && property.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(property.getDefault());
        }
        if ((style & 0x80) != 0 && !(modifiers = PropertyUtil.getModifiersAsString(property, multiLine = (style & 0x400) != 0)).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            if (!buffer.toString().endsWith(" ")) {
                buffer.append(" ");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }
}

