/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import com.google.common.collect.Lists;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.MultiViewPageBookView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ModelExplorerPageBookView
extends MultiViewPageBookView
implements IGotoMarker,
ITabbedPropertySheetPageContributor {
    public static final String VIEW_ID = "org.eclipse.papyrus.views.modelexplorer.modelexplorer";

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        ModelExplorerPage page = new ModelExplorerPage();
        this.initPage(page, part);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class == adapter) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return "TreeOutlinePage";
    }

    public void gotoMarker(IMarker marker) {
        String uriAttribute = marker.getAttribute("uri", null);
        if (uriAttribute != null) {
            ModelExplorerView modelExplorerView;
            EditingDomain domain;
            EObject eObject;
            URI uri = URI.createURI((String)uriAttribute);
            IViewPart viewPart = this.getActiveView();
            if (viewPart instanceof ModelExplorerView && (eObject = (domain = (modelExplorerView = (ModelExplorerView)viewPart).getEditingDomain()).getResourceSet().getEObject(uri, false)) != null) {
                CommonViewer treeViewer = ((ModelExplorerView)viewPart).getCommonViewer();
                ModelExplorerView.reveal(Lists.newArrayList((Object[])new EObject[]{eObject}), treeViewer);
            }
        }
    }
}

