/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorUtils {
    public static IViewPart findViewPart(final String viewID) {
        RunnableWithResult.Impl<IViewPart> runnable = new RunnableWithResult.Impl<IViewPart>(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) {
                    this.setResult(null);
                    return;
                }
                IViewReference reference = page.findViewReference(viewID);
                if (reference == null) {
                    this.setResult(null);
                    return;
                }
                IWorkbenchPart part = reference.getPart(false);
                if (part instanceof IViewPart) {
                    this.setResult((IViewPart)part);
                    return;
                }
                this.setResult(null);
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (IViewPart)runnable.getResult();
    }

    public static ISelection unwrapSelection(ISelection selection) {
        if (selection instanceof StructuredSelection && !selection.isEmpty()) {
            ArrayList<EObject> selectionList = new ArrayList<EObject>();
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            for (Object next : structuredSelection) {
                EObject eObject;
                EObject element;
                if (next instanceof EditPart) {
                    Object model = ((EditPart)next).getModel();
                    EObject element2 = null;
                    if (model instanceof View) {
                        element2 = ((View)model).getElement();
                    } else if (model instanceof EObject) {
                        element2 = (EObject)model;
                    }
                    if (element2 != null) {
                        selectionList.add(element2);
                    }
                } else if (next instanceof View && (element = ((View)next).getElement()) != null) {
                    selectionList.add(element);
                }
                if ((eObject = EMFHelper.getEObject(next)) == null) continue;
                selectionList.add(eObject);
            }
            return new StructuredSelection(selectionList);
        }
        return selection;
    }

    public static List<EditPart> getEditPartsFromSelection(ISelection selection, IDiagramGraphicalViewer viewer) {
        if (selection instanceof StructuredSelection && !selection.isEmpty()) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            ArrayList<View> views = new ArrayList<View>();
            for (Object o : structuredSelection.toList()) {
                if (!(o instanceof EObject)) continue;
                List<Object> referencerViews = NavigatorUtils.getEObjectViews((EObject)o);
                for (Object ro : referencerViews) {
                    if (!(ro instanceof View)) continue;
                    views.add((View)ro);
                }
            }
            if (!views.isEmpty()) {
                ArrayList<EditPart> editParts = new ArrayList<EditPart>();
                for (View view : views) {
                    Object ep = viewer.getEditPartRegistry().get(view);
                    if (!(ep instanceof EditPart)) continue;
                    editParts.add((EditPart)ep);
                }
                if (!editParts.isEmpty()) {
                    return editParts;
                }
            }
        }
        return Collections.emptyList();
    }

    public static List<Object> getEObjectViews(EObject element) {
        ArrayList<Object> views = new ArrayList<Object>();
        if (element != null) {
            EReference[] features = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
            Collection referencers = EMFCoreUtil.getReferencers((EObject)element, (EReference[])features);
            views.addAll(referencers);
        }
        return views;
    }

    public static void openViewPart(String viewPartID) {
        if (viewPartID == null) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewPartID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public static void openPropertySheetsView() {
        NavigatorUtils.openViewPart("org.eclipse.ui.views.PropertySheet");
    }

    public static <T> T getElement(Object o, Class<T> theClass) {
        Object result = null;
        if (o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            result = adaptable.getAdapter(theClass);
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(o, theClass);
        }
        if (result == null && theClass.isInstance(o)) {
            result = o;
        }
        return (T)result;
    }

    public static boolean any(EObject referencedElement, final EClass type, final boolean searchAllContents, Predicate<EObject> predicate) {
        if (referencedElement == null || referencedElement.eResource() == null || referencedElement.eResource().getResourceSet() == null) {
            return false;
        }
        ResourceSet resourceSet = referencedElement.eResource().getResourceSet();
        Predicate composedPredicate = Predicates.and((Predicate)new Predicate<EObject>(){

            public boolean apply(EObject arg0) {
                return type.isSuperTypeOf(arg0.eClass());
            }
        }, predicate);
        for (final Resource resource : resourceSet.getResources()) {
            Iterable<EObject> iterable = new Iterable<EObject>(){

                @Override
                public Iterator<EObject> iterator() {
                    TreeIterator allContentsIterator;
                    if (searchAllContents) {
                        allContentsIterator = resource.getAllContents();
                    } else {
                        LinkedList<EObject> contentsToBrowse = new LinkedList<EObject>();
                        for (EObject rootElement : resource.getContents()) {
                            if (rootElement.eClass().getEPackage() != type.getEPackage()) continue;
                            contentsToBrowse.add(rootElement);
                        }
                        allContentsIterator = EcoreUtil.getAllProperContents(contentsToBrowse, (boolean)false);
                    }
                    return allContentsIterator;
                }
            };
            if (!Iterables.any((Iterable)iterable, (Predicate)composedPredicate)) continue;
            return true;
        }
        return false;
    }

    public static boolean find(EObject toFind, Predicate<EStructuralFeature.Setting> predicate) {
        if (toFind == null || toFind.eResource() == null || toFind.eResource().getResourceSet() == null) {
            return false;
        }
        ResourceSet resourceSet = toFind.eResource().getResourceSet();
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new ECrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)adapter);
        }
        Collection settings = adapter.getInverseReferences(toFind, false);
        return Iterables.any((Iterable)settings, predicate);
    }

    public static <T> Collection<T> findFilterAndApply(EObject toFind, Predicate<EStructuralFeature.Setting> predicate, Function<EStructuralFeature.Setting, T> function) {
        if (toFind == null || toFind.eResource() == null || toFind.eResource().getResourceSet() == null) {
            return Collections.emptyList();
        }
        ResourceSet resourceSet = toFind.eResource().getResourceSet();
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new ECrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)adapter);
        }
        Collection settings = adapter.getInverseReferences(toFind, false);
        return Lists.newLinkedList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)settings, predicate), function));
    }
}

