/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.provider;

import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IOpenable;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.ui.IWorkbenchPart;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    public static final String IS_EOBJECT = "isEObject";
    public static final String IS_MODEL_EXPLORER = "isModelExplorer";
    public static final String IS_PAGE = "isPage";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_EOBJECT.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isObject((IStructuredSelection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        if (IS_MODEL_EXPLORER.equals(property) && receiver instanceof IWorkbenchPart) {
            boolean answer = this.isModelExplorer((IWorkbenchPart)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        if (IS_PAGE.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isPage((IStructuredSelection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        return false;
    }

    private boolean isPage(IStructuredSelection selection) {
        IPageManager pageManager = this.getPageManager();
        if (pageManager != null && !selection.isEmpty()) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                EObject current = EMFHelper.getEObject(iter.next());
                if (this.isPage(current, pageManager)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isPage(EObject element, IPageManager pageManager) {
        if (pageManager.allPages().contains(element)) {
            return true;
        }
        Object openable = Platform.getAdapterManager().getAdapter((Object)element, IOpenable.class);
        return openable instanceof IOpenable;
    }

    protected IPageManager getPageManager() {
        IPageManager pageMngr = null;
        try {
            ServiceUtilsForActionHandlers instance = ServiceUtilsForActionHandlers.getInstance();
            if (instance != null) {
                pageMngr = instance.getIPageManager();
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return pageMngr;
    }

    private boolean isModelExplorer(IWorkbenchPart receiver) {
        return receiver instanceof ModelExplorerPageBookView;
    }

    private boolean isObject(IStructuredSelection selection) {
        Iterator iter;
        if (!selection.isEmpty() && (iter = selection.iterator()).hasNext()) {
            EObject current = EMFHelper.getEObject(iter.next());
            return current != null;
        }
        return false;
    }
}

