/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.internal.core;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.papyrus.xwt.XWTException;
import org.eclipse.papyrus.xwt.metadata.ModelUtils;

public class BindingExpressionPath {
    protected String fullPath;
    protected String stripedPath;
    protected String[] segments;

    public BindingExpressionPath(String value) {
        if (value == null) {
            return;
        }
        this.fullPath = value;
        this.stripedPath = null;
        int level = 0;
        Stack<Character> separators = new Stack<Character>();
        ArrayList<String> collector = new ArrayList<String>();
        int start = 0;
        int stripStart = 0;
        int stripEnd = 0;
        char[] array = value.toCharArray();
        int i = 0;
        while (i < array.length) {
            switch (array[i]) {
                case '}': {
                    Character character = (Character)separators.pop();
                    if (character.charValue() != '{') {
                        throw new XWTException("Syntax error is binding expression " + value + " at " + i);
                    }
                    --level;
                    break;
                }
                case ']': {
                    Character character = (Character)separators.pop();
                    if (character.charValue() != '[') {
                        throw new XWTException("Syntax error is binding expression " + value + " at " + i);
                    }
                    --level;
                    break;
                }
                case ')': {
                    Character character = (Character)separators.pop();
                    if (character.charValue() != '(') {
                        throw new XWTException("Syntax error is binding expression " + value + " at " + i);
                    }
                    if (--level != 0) break;
                    stripEnd = i - 1;
                    break;
                }
                case '(': {
                    if (level == 0) {
                        stripStart = i + 1;
                    }
                    separators.push(Character.valueOf(array[i]));
                    ++level;
                    break;
                }
                case '[': 
                case '{': {
                    separators.push(Character.valueOf(array[i]));
                    ++level;
                    break;
                }
                case '.': {
                    if (level != 0) break;
                    String element = value.substring(start, i);
                    element = ModelUtils.normalizePropertyName(element);
                    collector.add(element);
                    this.updateStripped(value, stripStart, stripEnd, element);
                    start = i + 1;
                }
            }
            ++i;
        }
        if (level == 0) {
            String element = value.substring(start, array.length);
            element = ModelUtils.normalizePropertyName(element);
            collector.add(element);
            this.updateStripped(value, stripStart, stripEnd, element);
        }
        this.segments = collector.toArray(new String[collector.size()]);
    }

    private void updateStripped(String value, int stripStart, int stripEnd, String element) {
        if (stripStart != 0) {
            element = value.substring(stripStart, stripEnd + 1);
            int index = element.lastIndexOf(46);
            if (index != -1) {
                element = element.substring(index + 1);
            }
            element = ModelUtils.normalizePropertyName(element);
        }
        this.stripedPath = this.stripedPath == null ? element : String.valueOf(this.stripedPath) + "." + element;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getStripedPath() {
        return this.stripedPath;
    }

    public String[] getSegments() {
        return this.segments;
    }

    public boolean isEmptyPath() {
        return BindingExpressionPath.isEmptyPath(this.getFullPath());
    }

    public static boolean isEmptyPath(String value) {
        return value == null || value.trim().length() == 0 || ".".equals(value.trim());
    }

    public static int lastIndexOf(String value) {
        int level = 0;
        Stack<Character> separators = new Stack<Character>();
        char[] array = value.toCharArray();
        int i = array.length - 1;
        while (i >= 0) {
            switch (array[i]) {
                case '{': {
                    Character character = (Character)separators.pop();
                    if (character.charValue() != '}') {
                        throw new XWTException("Syntax error is binding expression " + value + " at " + i);
                    }
                    --level;
                    break;
                }
                case '[': {
                    Character character = (Character)separators.pop();
                    if (character.charValue() != '}') {
                        throw new XWTException("Syntax error is binding expression " + value + " at " + i);
                    }
                    --level;
                    break;
                }
                case '(': {
                    Character character = (Character)separators.pop();
                    if (character.charValue() != ')') {
                        throw new XWTException("Syntax error is binding expression " + value + " at " + i);
                    }
                    --level;
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    separators.push(Character.valueOf(array[i]));
                    ++level;
                    break;
                }
                case '.': {
                    if (level != 0) break;
                    return i;
                }
            }
            char cfr_ignored_0 = array[i];
            --i;
        }
        return -1;
    }
}

