/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public abstract class AbstractBundleContainer
extends PlatformObject
implements ITargetLocation {
    protected TargetBundle[] fBundles;
    protected TargetFeature[] fFeatures;
    private IStatus fResolutionStatus;
    private String[] fVMArgs;

    protected String resolveVariables(String text) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(text);
    }

    public final boolean isResolved() {
        return this.fResolutionStatus != null && this.fResolutionStatus.getSeverity() != 8;
    }

    public final IStatus resolve(ITargetDefinition definition, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)150);
        try {
            try {
                this.fBundles = this.resolveBundles(definition, (IProgressMonitor)subMonitor.newChild(100));
                this.fFeatures = this.resolveFeatures(definition, (IProgressMonitor)subMonitor.newChild(50));
                this.fResolutionStatus = Status.OK_STATUS;
                if (subMonitor.isCanceled()) {
                    this.fBundles = null;
                    this.fResolutionStatus = Status.CANCEL_STATUS;
                }
            }
            catch (CoreException e) {
                this.fBundles = new TargetBundle[0];
                this.fFeatures = new TargetFeature[0];
                this.fResolutionStatus = e.getStatus();
                subMonitor.done();
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            subMonitor.done();
            if (monitor != null) {
                monitor.done();
            }
        }
        return this.fResolutionStatus;
    }

    public IStatus getStatus() {
        if (!this.isResolved()) {
            return null;
        }
        return this.fResolutionStatus;
    }

    public final TargetBundle[] getBundles() {
        if (this.isResolved()) {
            return this.fBundles;
        }
        return null;
    }

    public TargetFeature[] getFeatures() {
        if (this.isResolved()) {
            return this.fFeatures;
        }
        return null;
    }

    protected abstract TargetBundle[] resolveBundles(ITargetDefinition var1, IProgressMonitor var2) throws CoreException;

    protected abstract TargetFeature[] resolveFeatures(ITargetDefinition var1, IProgressMonitor var2) throws CoreException;

    public abstract String getType();

    public abstract String getLocation(boolean var1) throws CoreException;

    protected void clearResolutionStatus() {
        this.fResolutionStatus = null;
    }

    public String[] getVMArguments() {
        String FWK_ADMIN_EQ = "org.eclipse.equinox.frameworkadmin.equinox";
        if (this.fVMArgs == null) {
            try {
                Bundle fwAdminBundle;
                FrameworkAdmin fwAdmin = (FrameworkAdmin)PDECore.getDefault().acquireService(FrameworkAdmin.class.getName());
                if (fwAdmin == null && (fwAdminBundle = Platform.getBundle((String)FWK_ADMIN_EQ)) != null) {
                    fwAdminBundle.start();
                    fwAdmin = (FrameworkAdmin)PDECore.getDefault().acquireService(FrameworkAdmin.class.getName());
                }
                if (fwAdmin != null) {
                    Manipulator manipulator = fwAdmin.getManipulator();
                    ConfigData configData = new ConfigData(null, null, null, null);
                    String home = this.getLocation(true);
                    manipulator.getLauncherData().setLauncher(new File(home, "eclipse"));
                    File installDirectory = new File(home);
                    if (Platform.getOS().equals("macosx")) {
                        installDirectory = new File(installDirectory, "Eclipse.app/Contents/MacOS");
                    }
                    manipulator.getLauncherData().setLauncherConfigLocation(new File(installDirectory, "eclipse.ini"));
                    manipulator.getLauncherData().setHome(new File(home));
                    manipulator.setConfigData(configData);
                    manipulator.load();
                    this.fVMArgs = manipulator.getLauncherData().getJvmArgs();
                }
            }
            catch (BundleException e) {
                PDECore.log(e);
            }
            catch (CoreException e) {
                PDECore.log(e);
            }
            catch (IOException e) {
                PDECore.log(e);
            }
        }
        if (this.fVMArgs == null || this.fVMArgs.length == 0) {
            return null;
        }
        return this.fVMArgs;
    }

    protected void associateWithTarget(ITargetDefinition target) {
    }

    public String serialize() {
        return null;
    }
}

