/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.XMLSourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionAttributePointDectector;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestHyperlinkDetector;
import org.eclipse.pde.internal.ui.editor.plugin.PluginFoldingStructureProvider;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.refactoring.PDERefactoringAction;
import org.eclipse.pde.internal.ui.refactoring.RefactoringActionFactory;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.ActionContext;

public class ManifestSourcePage
extends XMLSourcePage {
    private Object fLibraries = new Object();
    private Object fImports = new Object();
    private Object fExtensionPoints = new Object();
    private Object fExtensions = new Object();
    private ExtensionAttributePointDectector fDetector = new ExtensionAttributePointDectector();
    private PluginSearchActionGroup fActionGroup = new PluginSearchActionGroup();
    private PDERefactoringAction fRenameAction;

    public ManifestSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public ILabelProvider createOutlineLabelProvider() {
        return new OutlineLabelProvider();
    }

    public ITreeContentProvider createOutlineContentProvider() {
        return new ContentProvider();
    }

    public void updateSelection(Object object) {
        if (object instanceof IDocumentElementNode && !((IDocumentElementNode)object).isErrorNode()) {
            this.setSelectedObject(object);
            this.setHighlightRange((IDocumentRange)((IDocumentElementNode)object), true);
            this.setSelectedRange((IDocumentRange)((IDocumentElementNode)object), false);
        }
    }

    public ViewerComparator createOutlineComparator() {
        return new OutlineComparator();
    }

    public IDocumentRange getRangeElement(int offset, boolean searchChildren) {
        IPluginBase base = ((IPluginModelBase)this.getInputContext().getModel()).getPluginBase(false);
        if (base == null) {
            return null;
        }
        IDocumentRange node = this.findNode(base.getLibraries(), offset, searchChildren);
        if (node == null) {
            node = this.findNode(base.getImports(), offset, searchChildren);
        }
        if (node == null) {
            node = this.findNode(base.getExtensionPoints(), offset, searchChildren);
        }
        if (node == null) {
            node = this.findNode(base.getExtensions(), offset, searchChildren);
        }
        if (node == null) {
            node = this.findNode(new IPluginObject[]{base}, offset, searchChildren);
        }
        return node;
    }

    public IDocumentRange findRange() {
        Object selectedObject = this.getSelection();
        if (selectedObject instanceof ImportObject) {
            selectedObject = ((ImportObject)selectedObject).getImport();
            this.setSelectedObject(selectedObject);
        }
        if (selectedObject instanceof IDocumentElementNode) {
            return (IDocumentElementNode)selectedObject;
        }
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (IHyperlinkDetector.class.equals((Object)adapter)) {
            return new ManifestHyperlinkDetector(this);
        }
        return super.getAdapter(adapter);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        ISelection selection = this.fDetector.getSelection();
        if (selection != null) {
            this.fActionGroup.setContext(new ActionContext(selection));
            this.fActionGroup.fillContextMenu(menu);
        }
        super.editorContextMenuAboutToShow(menu);
        StyledText text = this.getViewer().getTextWidget();
        Point p = text.getSelection();
        IDocumentRange element = this.getRangeElement(p.x, false);
        if (!(element instanceof IPluginExtensionPoint)) {
            return;
        }
        if (this.isEditable()) {
            if (this.fRenameAction == null) {
                this.fRenameAction = RefactoringActionFactory.createRefactorExtPointAction(PDEUIMessages.ManifestSourcePage_renameActionText);
            }
            if (this.fRenameAction != null) {
                this.fRenameAction.setSelection(element);
                menu.insertAfter("org.eclipse.pde.ui.quickOutline", (IAction)this.fRenameAction);
            }
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fDetector.setTextEditor(this);
    }

    public boolean isQuickOutlineEnabled() {
        return true;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.updateTextSelection();
        }
    }

    protected IFoldingStructureProvider getFoldingStructureProvider(IEditingModel model) {
        return new PluginFoldingStructureProvider(this, model);
    }

    class ContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            PluginModelBase model = (PluginModelBase)ManifestSourcePage.this.getInputContext().getModel();
            ArrayList<Object> result = new ArrayList<Object>();
            if (parent instanceof IPluginBase) {
                IPluginBase pluginBase = (IPluginBase)parent;
                if (pluginBase.getLibraries().length > 0) {
                    result.add(ManifestSourcePage.this.fLibraries);
                }
                if (pluginBase.getImports().length > 0) {
                    result.add(ManifestSourcePage.this.fImports);
                }
                if (pluginBase.getExtensionPoints().length > 0) {
                    result.add(ManifestSourcePage.this.fExtensionPoints);
                }
                if (pluginBase.getExtensions().length > 0) {
                    result.add(ManifestSourcePage.this.fExtensions);
                }
                return result.toArray();
            }
            if (parent == ManifestSourcePage.this.fLibraries) {
                return model.getPluginBase().getLibraries();
            }
            if (parent == ManifestSourcePage.this.fImports) {
                return model.getPluginBase().getImports();
            }
            if (parent == ManifestSourcePage.this.fExtensionPoints) {
                return model.getPluginBase().getExtensionPoints();
            }
            if (parent == ManifestSourcePage.this.fExtensions) {
                return model.getPluginBase().getExtensions();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IDocumentElementNode) {
                return ((IDocumentElementNode)element).getParentNode();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IPluginBase) {
                return ((IDocumentElementNode)element).getChildNodes().length > 0;
            }
            return element == ManifestSourcePage.this.fLibraries || element == ManifestSourcePage.this.fImports || element == ManifestSourcePage.this.fExtensionPoints || element == ManifestSourcePage.this.fExtensions;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IPluginModelBase) {
                return new Object[]{((IPluginModelBase)inputElement).getPluginBase()};
            }
            return new Object[0];
        }
    }

    class OutlineComparator
    extends ViewerComparator {
        OutlineComparator() {
        }

        public int category(Object element) {
            if (element == ManifestSourcePage.this.fLibraries) {
                return 0;
            }
            if (element == ManifestSourcePage.this.fImports) {
                return 1;
            }
            if (element == ManifestSourcePage.this.fExtensionPoints) {
                return 2;
            }
            if (element == ManifestSourcePage.this.fExtensions) {
                return 3;
            }
            return 4;
        }
    }

    class OutlineLabelProvider
    extends LabelProvider {
        private PDELabelProvider fProvider = PDEPlugin.getDefault().getLabelProvider();

        public String getText(Object obj) {
            if (obj == ManifestSourcePage.this.fLibraries) {
                return PDEUIMessages.ManifestSourcePage_libraries;
            }
            if (obj == ManifestSourcePage.this.fImports) {
                return PDEUIMessages.ManifestSourcePage_dependencies;
            }
            if (obj == ManifestSourcePage.this.fExtensionPoints) {
                return PDEUIMessages.ManifestSourcePage_extensionPoints;
            }
            if (obj == ManifestSourcePage.this.fExtensions) {
                return PDEUIMessages.ManifestSourcePage_extensions;
            }
            String text = this.fProvider.getText(obj);
            if ((text == null || text.trim().length() == 0) && obj instanceof IDocumentElementNode) {
                text = ((IDocumentElementNode)obj).getXMLTagName();
            }
            return text;
        }

        public Image getImage(Object obj) {
            if (obj == ManifestSourcePage.this.fLibraries) {
                return this.fProvider.get(PDEPluginImages.DESC_RUNTIME_OBJ);
            }
            if (obj == ManifestSourcePage.this.fImports) {
                return this.fProvider.get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
            }
            if (obj == ManifestSourcePage.this.fExtensionPoints) {
                return this.fProvider.get(PDEPluginImages.DESC_EXT_POINTS_OBJ);
            }
            if (obj == ManifestSourcePage.this.fExtensions) {
                return this.fProvider.get(PDEPluginImages.DESC_EXTENSIONS_OBJ);
            }
            Image image = this.fProvider.getImage(obj);
            int flags = ((IDocumentElementNode)obj).isErrorNode() ? 1 : 0;
            return flags == 0 ? image : this.fProvider.get(image, flags);
        }
    }
}

