/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.imagebrowser.filter;

import org.eclipse.pde.internal.ui.views.imagebrowser.ImageElement;
import org.eclipse.pde.internal.ui.views.imagebrowser.filter.IFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeFilter
implements IFilter<ImageElement> {
    public static final int TYPE_EXACT = 0;
    public static final int TYPE_BIGGER_EQUALS = 1;
    public static final int TYPE_SMALLER_EQUALS = 2;
    private final int mWidth;
    private final int mWidthType;
    private final int mHeight;
    private final int mHeightType;

    public SizeFilter(int width, int widthType, int height, int heightType) {
        this.mWidth = width;
        this.mWidthType = widthType;
        this.mHeight = height;
        this.mHeightType = heightType;
    }

    @Override
    public boolean accept(ImageElement element) {
        boolean accept = true;
        switch (this.mWidthType) {
            case 0: {
                accept &= element.getImageData().width == this.mWidth;
                break;
            }
            case 1: {
                accept &= element.getImageData().width >= this.mWidth;
                break;
            }
            case 2: {
                accept &= element.getImageData().width <= this.mWidth;
            }
        }
        switch (this.mHeightType) {
            case 0: {
                accept &= element.getImageData().height == this.mHeight;
                break;
            }
            case 1: {
                accept &= element.getImageData().height >= this.mHeight;
                break;
            }
            case 2: {
                accept &= element.getImageData().height <= this.mHeight;
            }
        }
        return accept;
    }
}

