/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.DocumentSection;
import org.eclipse.pde.internal.core.schema.EditableSchema;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaRootElement;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class BaseExtensionPointMainPage
extends WizardPage {
    public static final String SETTINGS_PLUGIN_ID = "BaseExtensionPoint.settings.pluginId";
    public static final String SCHEMA_DIR = "schema";
    protected IContainer fContainer;
    protected Text fIdText;
    protected Text fPluginIdText;
    protected Text fNameText;
    protected Text fSchemaText;
    protected Text fSchemaLocationText;
    protected Button fOpenSchemaButton;
    protected Button fSharedSchemaButton;
    protected Button fPluginBrowseButton;
    protected Button fFindLocationButton;

    public BaseExtensionPointMainPage(IContainer container) {
        super("newExtensionPoint");
        this.fContainer = container;
    }

    public void createControl(Composite parent) {
        GridData gd;
        Label label;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        if (this.isPluginIdNeeded()) {
            label = new Label(container, 0);
            label.setText(PDEUIMessages.BaseExtensionPoint_pluginId);
            this.fPluginIdText = new Text(container, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            gd.widthHint = 275;
            this.fPluginIdText.setLayoutData((Object)gd);
            this.fPluginIdText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BaseExtensionPointMainPage.this.validatePage();
                }
            });
            this.fPluginBrowseButton = new Button(container, 8);
            gd = new GridData(128);
            gd.horizontalSpan = 1;
            gd.widthHint = 50;
            this.fPluginBrowseButton.setLayoutData((Object)gd);
            this.fPluginBrowseButton.setText(PDEUIMessages.BaseExtensionPointMainPage_pluginBrowse);
            this.fPluginBrowseButton.setToolTipText(PDEUIMessages.BaseExtensionPointMainPage_pluginId_tooltip);
            this.fPluginBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseExtensionPointMainPage.this.handlePluginBrowse();
                }
            });
            SWTUtil.setButtonDimensionHint(this.fPluginBrowseButton);
        }
        label = new Label(container, 0);
        label.setText(PDEUIMessages.BaseExtensionPoint_id);
        this.fIdText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fIdText.setLayoutData((Object)gd);
        this.fIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExtensionPointMainPage.this.fSchemaText.setText(String.valueOf(BaseExtensionPointMainPage.this.getSchemaLocation()) + (BaseExtensionPointMainPage.this.getSchemaLocation().length() > 0 ? "/" : "") + BaseExtensionPointMainPage.this.fIdText.getText() + ".exsd");
            }
        });
        label = new Label(container, 0);
        label.setText(PDEUIMessages.BaseExtensionPoint_name);
        this.fNameText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExtensionPointMainPage.this.validatePage();
            }
        });
        if (this.isPluginIdNeeded() && !this.isPluginIdFinal()) {
            label = new Label(container, 0);
            label.setText(PDEUIMessages.BaseExtensionPoint_schemaLocation);
            this.fSchemaLocationText = new Text(container, 2052);
            gd = new GridData(768);
            gd.widthHint = 150;
            gd.grabExcessHorizontalSpace = true;
            this.fSchemaLocationText.setLayoutData((Object)gd);
            this.fSchemaLocationText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BaseExtensionPointMainPage.this.validatePage();
                }
            });
            this.fFindLocationButton = new Button(container, 8);
            gd = new GridData(128);
            gd.widthHint = 50;
            this.fFindLocationButton.setLayoutData((Object)gd);
            this.fFindLocationButton.setText(PDEUIMessages.BaseExtensionPointMainPage_findBrowse);
            this.fFindLocationButton.setToolTipText(PDEUIMessages.BaseExtensionPointMainPage_schemaLocation_tooltip);
            this.fFindLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseExtensionPointMainPage.this.handleSchemaLocation();
                }
            });
            SWTUtil.setButtonDimensionHint(this.fFindLocationButton);
        }
        label = new Label(container, 0);
        label.setText(PDEUIMessages.BaseExtensionPoint_schema);
        this.fSchemaText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fSchemaText.setLayoutData((Object)gd);
        this.fSchemaText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExtensionPointMainPage.this.validatePage();
            }
        });
        if (this.isSharedSchemaSwitchNeeded()) {
            this.fSharedSchemaButton = new Button(container, 32);
            this.fSharedSchemaButton.setText(PDEUIMessages.BaseExtensionPoint_shared);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.fSharedSchemaButton.setLayoutData((Object)gd);
        }
        this.fOpenSchemaButton = new Button(container, 32);
        this.fOpenSchemaButton.setText(PDEUIMessages.BaseExtensionPoint_edit);
        this.fOpenSchemaButton.setSelection(true);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fOpenSchemaButton.setLayoutData((Object)gd);
        if (this.isPluginIdNeeded()) {
            this.fPluginIdText.setFocus();
        } else {
            this.fIdText.setFocus();
        }
        this.setControl((Control)container);
        this.initializeValues();
        this.validatePage();
        String error = this.getErrorMessage();
        if (error != null) {
            this.setMessage(error);
            this.setErrorMessage(null);
        }
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.new_schema");
    }

    private InputStream createSchemaStream(String pluginId, String pointId, String name, boolean shared, IFile schemaFile) {
        if (name.length() == 0) {
            name = pointId;
        }
        EditableSchema schema = new EditableSchema(pluginId, pointId, name, false);
        schema.setDescription(PDEUIMessages.BaseExtensionPoint_sections_overview);
        DocumentSection section = new DocumentSection((ISchemaObject)schema, "since", PDEUIMessages.BaseExtensionPointMainPage_since);
        section.setDescription(PDEUIMessages.BaseExtensionPoint_sections_since);
        schema.addDocumentSection(section);
        if (!shared) {
            SchemaRootElement element = new SchemaRootElement((ISchemaObject)schema, "extension");
            SchemaComplexType complexType = new SchemaComplexType((ISchema)schema);
            element.setType((ISchemaType)complexType);
            SchemaAttribute attribute = new SchemaAttribute((ISchemaObject)element, "point");
            attribute.setType((ISchemaSimpleType)new SchemaSimpleType((ISchema)schema, "string"));
            attribute.setUse(1);
            complexType.addAttribute((ISchemaAttribute)attribute);
            attribute = new SchemaAttribute((ISchemaObject)element, "id");
            attribute.setType((ISchemaSimpleType)new SchemaSimpleType((ISchema)schema, "string"));
            complexType.addAttribute((ISchemaAttribute)attribute);
            attribute = new SchemaAttribute((ISchemaObject)element, "name");
            attribute.setType((ISchemaSimpleType)new SchemaSimpleType((ISchema)schema, "string"));
            attribute.setTranslatableProperty(true);
            complexType.addAttribute((ISchemaAttribute)attribute);
            schema.addElement((ISchemaElement)element);
        }
        section = new DocumentSection((ISchemaObject)schema, "examples", "Examples");
        section.setDescription(PDEUIMessages.BaseExtensionPoint_sections_usage);
        schema.addDocumentSection(section);
        section = new DocumentSection((ISchemaObject)schema, "apiinfo", "API Information");
        section.setDescription(PDEUIMessages.BaseExtensionPoint_sections_api);
        schema.addDocumentSection(section);
        section = new DocumentSection((ISchemaObject)schema, "implementation", "Supplied Implementation");
        section.setDescription(PDEUIMessages.BaseExtensionPoint_sections_supplied);
        schema.addDocumentSection(section);
        section = new DocumentSection((ISchemaObject)schema, "copyright", "Copyright");
        section.setDescription(PDEUIMessages.BaseExtensionPoint_sections_copyright);
        schema.addDocumentSection(section);
        StringWriter swriter = new StringWriter();
        try {
            PrintWriter writer = new PrintWriter((Writer)swriter, true);
            schema.save(writer);
            swriter.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        try {
            String content = swriter.toString();
            content = AbstractModel.fixLineDelimiter((String)content, (IFile)schemaFile);
            return new ByteArrayInputStream(content.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private IFile generateSchemaFile(String pluginId, String id, String name, boolean shared, String schema, IProgressMonitor monitor) throws CoreException {
        IFile schemaFile = null;
        IWorkspace workspace = this.fContainer.getWorkspace();
        IPath schemaPath = new Path(schema).removeLastSegments(1);
        IPath newSchemaPath = this.fContainer.getProjectRelativePath().append(schemaPath);
        monitor.subTask(PDEUIMessages.BaseExtensionPoint_generating);
        if (!newSchemaPath.isEmpty()) {
            IFolder folder = this.fContainer.getProject().getFolder(newSchemaPath);
            CoreUtility.createFolder((IFolder)folder);
        }
        IPath filePath = this.fContainer.getFullPath().append(schema);
        schemaFile = workspace.getRoot().getFile(filePath);
        InputStream source = this.createSchemaStream(pluginId, id, name, shared, schemaFile);
        if (!schemaFile.exists()) {
            schemaFile.create(source, true, monitor);
        } else {
            schemaFile.setContents(source, true, false, monitor);
        }
        IDE.setDefaultEditor((IFile)schemaFile, (String)"org.eclipse.pde.ui.schemaEditor");
        return schemaFile;
    }

    public IRunnableWithProgress getOperation() {
        final boolean openFile = this.fOpenSchemaButton.getSelection();
        final String id = this.fIdText.getText();
        final String name = this.fNameText.getText();
        final String schema = this.fSchemaText.getText();
        final boolean shared = this.fSharedSchemaButton != null ? this.fSharedSchemaButton.getSelection() : false;
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(final IProgressMonitor monitor) {
                try {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            IFile file;
                            String schemaName = schema;
                            if (!schema.endsWith(".exsd")) {
                                schemaName = String.valueOf(schema) + ".exsd";
                            }
                            if (!(file = (this).BaseExtensionPointMainPage.this.fContainer.getFile((IPath)new Path(schema))).exists()) {
                                try {
                                    file = BaseExtensionPointMainPage.this.generateSchemaFile(BaseExtensionPointMainPage.this.getPluginId(), id, name, shared, schemaName, monitor);
                                }
                                catch (CoreException e) {
                                    PDEPlugin.logException(e);
                                }
                            }
                            if (file != null && openFile) {
                                (this).BaseExtensionPointMainPage.this.fSchemaText.setText(file.getProjectRelativePath().toString());
                                BaseExtensionPointMainPage.this.openSchemaFile(file);
                            }
                        }
                    });
                }
                finally {
                    monitor.done();
                }
            }
        };
        return operation;
    }

    public String getSchemaLocation() {
        if (this.fSchemaText != null) {
            String schema = this.fSchemaText.getText();
            if (schema.length() == 0) {
                if (this.fSchemaLocationText != null && SCHEMA_DIR.equals(new Path(this.fSchemaLocationText.getText()).lastSegment())) {
                    return "";
                }
                return SCHEMA_DIR;
            }
            int loc = schema.lastIndexOf("/");
            if (loc != -1) {
                return schema.substring(0, loc);
            }
        }
        return "";
    }

    public String getPluginId() {
        if (this.fPluginIdText != null) {
            return this.fPluginIdText.getText();
        }
        return "";
    }

    protected boolean isPluginIdNeeded() {
        return false;
    }

    protected boolean isPluginIdFinal() {
        return false;
    }

    protected boolean isSharedSchemaSwitchNeeded() {
        return false;
    }

    private void openSchemaFile(final IFile file) {
        final IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
        Display d = ww.getShell().getDisplay();
        d.asyncExec(new Runnable(){

            public void run() {
                try {
                    String editorId = "org.eclipse.pde.ui.schemaEditor";
                    ww.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorId);
                }
                catch (PartInitException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }

    private void validatePage() {
        this.setMessage(null);
        String message = this.validateFieldContents();
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    protected abstract String validateFieldContents();

    protected abstract void initializeValues();

    protected String validateExtensionPointID() {
        String id = this.fIdText.getText();
        if (id.length() == 0) {
            return PDEUIMessages.BaseExtensionPointMainPage_missingExtensionPointID;
        }
        String pluginID = this.getPluginId();
        IPluginModelBase model = PluginRegistry.findModel((String)pluginID);
        if (model == null) {
            return NLS.bind((String)PDEUIMessages.BaseExtensionPointMainPage_errorMsgPluginNotFound, (Object)pluginID);
        }
        String schemaVersion = model.getPluginBase().getSchemaVersion();
        if (schemaVersion == null || (double)Float.parseFloat(schemaVersion) >= 3.2) {
            if (!IdUtil.isValidCompositeID((String)id)) {
                return PDEUIMessages.BaseExtensionPointMainPage_invalidCompositeID;
            }
        } else if (!IdUtil.isValidSimpleID((String)id)) {
            return PDEUIMessages.BaseExtensionPointMainPage_invalidSimpleID;
        }
        return null;
    }

    protected String validateExtensionPointName() {
        if (this.fNameText.getText().length() == 0) {
            return PDEUIMessages.BaseExtensionPointMainPage_missingExtensionPointName;
        }
        return null;
    }

    protected String validateExtensionPointSchema() {
        if (this.fSchemaText.getText().length() == 0) {
            return PDEUIMessages.BaseExtensionPointMainPage_missingExtensionPointSchema;
        }
        return null;
    }

    private void handlePluginBrowse() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.getShell(), PluginRegistry.getWorkspaceModels(), false);
        dialog.create();
        if (dialog.open() == 0) {
            IPluginModelBase workspaceModelBase = (IPluginModelBase)dialog.getFirstResult();
            this.fPluginIdText.setText(workspaceModelBase.getPluginBase().getId());
        }
    }

    private void handleSchemaLocation() {
        Object[] elements;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(PDEUIMessages.BaseExtensionPointMainPage_schemaLocation_title);
        dialog.setMessage(PDEUIMessages.BaseExtensionPointMainPage_schemaLocation_desc);
        dialog.setDoubleClickSelects(false);
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IFile);
            }
        });
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)this.fContainer);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.container_selection");
        if (dialog.open() == 0 && (elements = dialog.getResult()).length > 0) {
            IResource elem = (IResource)elements[0];
            String newPath = this.getWorkspaceRelativePath(elem.getLocation().toString());
            this.fSchemaLocationText.setText(String.valueOf(newPath) + "/");
        }
    }

    private String getWorkspaceRelativePath(String path) {
        String workspacePath = PDECore.getWorkspace().getRoot().getLocation().toString();
        if (path.startsWith(workspacePath)) {
            path = path.replaceFirst(workspacePath, "");
        }
        return path;
    }

    public String getInvalidIdMessage() {
        return null;
    }
}

