/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentificationVariable
extends AbstractExpression {
    private StateFieldPathExpression stateFieldPathExpression;
    private boolean virtual;

    IdentificationVariable(AbstractExpression parent, String identificationVariable) {
        super(parent, identificationVariable);
    }

    IdentificationVariable(AbstractExpression parent, String identificationVariable, boolean virtual) {
        super(parent, identificationVariable);
        this.virtual = virtual;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression(this.getText()));
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return IdentificationVariable.queryBNF("identification_variable");
    }

    public StateFieldPathExpression getStateFieldPathExpression() {
        if (!this.virtual) {
            throw new IllegalAccessError("IdentificationVariable.getStateFieldPathExpression() can only be accessed when it represents an attribute that is not fully qualified, which can be present in an UPDATE or DELETE query.");
        }
        return this.stateFieldPathExpression;
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward(this.getText());
    }

    void setVirtualIdentificationVariable(String variableName) {
        this.virtual = true;
        this.stateFieldPathExpression = new StateFieldPathExpression(this.getParent(), this.getText());
        this.stateFieldPathExpression.setVirtualIdentificationVariable(variableName);
        this.rebuildActualText();
        this.rebuildParsedText();
    }

    @Override
    public String toParsedText() {
        return this.getText();
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
    }
}

