/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.ui.editor.FortranEditor;
import org.eclipse.photran.internal.ui.editor.FortranStmtPartitionScanner;
import org.eclipse.photran.internal.ui.editor.FortranTemplateCompletionProcessor;
import org.eclipse.photran.internal.ui.editor_vpg.FortranEditorTasks;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProcessorASTTask;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProcessorVPGTask;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProposalComputer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class FortranCompletionProcessor
implements IContentAssistProcessor {
    ArrayList<String> scopes = new ArrayList();
    HashMap<String, TreeSet<Definition>> defs = new HashMap();
    private String errorMessage = null;
    private final Color LIGHT_YELLOW = new Color(null, new RGB(255, 255, 223));

    public IContentAssistant setup(FortranEditor editor) {
        String contentAssistEnabledProperty = new SearchPathProperties().getProperty(editor.getIFile(), "EnableContentAssist");
        if (contentAssistEnabledProperty != null && contentAssistEnabledProperty.equals("true")) {
            FortranEditorTasks.instance(editor).addASTTask(new FortranCompletionProcessorASTTask(this));
            FortranEditorTasks.instance(editor).addVPGTask(new FortranCompletionProcessorVPGTask(this));
            ContentAssistant assistant = new ContentAssistant();
            String[] stringArray = FortranStmtPartitionScanner.PARTITION_TYPES;
            int n = FortranStmtPartitionScanner.PARTITION_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String partitionType = stringArray[n2];
                assistant.setContentAssistProcessor((IContentAssistProcessor)this, partitionType);
                ++n2;
            }
            assistant.enableAutoActivation(false);
            assistant.setProposalPopupOrientation(21);
            assistant.setContextInformationPopupBackground(this.LIGHT_YELLOW);
            assistant.setProposalSelectorBackground(this.LIGHT_YELLOW);
            return assistant;
        }
        return null;
    }

    public synchronized ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        FortranCompletionProposalComputer computer = null;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(256);
        if (this.defs != null) {
            try {
                this.errorMessage = null;
                IDocument document = viewer.getDocument();
                int line = this.determineLineNumberForOffset(offset, document);
                String scopeName = this.determineScopeNameForLine(line);
                if (scopeName != null) {
                    computer = new FortranCompletionProposalComputer(this.defs, scopeName, document, offset);
                }
                if (computer != null) {
                    proposals.addAll(computer.proposalsFromDefs());
                }
                ICompletionProposal[] iCompletionProposalArray = new FortranTemplateCompletionProcessor().computeCompletionProposals(viewer, offset);
                int n = iCompletionProposalArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompletionProposal proposal = iCompletionProposalArray[n2];
                    proposals.add(proposal);
                    ++n2;
                }
                if (computer != null) {
                    proposals.addAll(computer.proposalsFromIntrinsics());
                }
            }
            catch (Exception e) {
                this.errorMessage = String.valueOf(e.getClass().getName()) + " - " + e.getMessage();
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private int determineLineNumberForOffset(int offset, IDocument document) throws BadLocationException {
        int line = document.getLineOfOffset(offset);
        if (!this.scopes.isEmpty() && line >= this.scopes.size()) {
            line = this.scopes.size() - 1;
        }
        return line;
    }

    private final String determineScopeNameForLine(int line) {
        String scopeName = "";
        if (line < this.scopes.size()) {
            scopeName = this.scopes.get(line);
        }
        if (scopeName == null) {
            scopeName = "";
        }
        while (scopeName.equals("") && line > 0) {
            if (--line >= this.scopes.size()) continue;
            scopeName = this.scopes.get(line);
        }
        return scopeName;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

