/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;

public class PHPDocClassVariableEvaluator
extends AbstractPHPGoalEvaluator {
    private static final String SPLASH = "\\";
    public static final String BRACKETS = "[]";
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();
    public static final Pattern ARRAY_TYPE_PATTERN = Pattern.compile("array\\[.*\\]");

    public PHPDocClassVariableEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        PHPDocClassVariableGoal typedGoal = (PHPDocClassVariableGoal)this.goal;
        TypeContext context = (TypeContext)typedGoal.getContext();
        String variableName = typedGoal.getVariableName();
        IType[] types = PHPTypeInferenceUtils.getModelElements(context.getInstanceType(), (ISourceModuleContext)context);
        HashMap<PHPDocBlock, IField> docs = new HashMap<PHPDocBlock, IField>();
        IModelAccessCache cache = context.getCache();
        if (types != null) {
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                block22: {
                    IType type = iTypeArray[n2];
                    try {
                        IType[] superTypes;
                        ITypeHierarchy superHierarchy = cache != null ? cache.getSuperTypeHierarchy(type, null) : type.newSupertypeHierarchy(null);
                        IType[] iTypeArray2 = superTypes = superHierarchy.getAllTypes();
                        int n3 = superTypes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PHPDocBlock docBlock;
                            IType superType = iTypeArray2[n4];
                            IField[] typeField = PHPModelUtils.getTypeField(superType, variableName, true);
                            if (typeField.length > 0 && (docBlock = PHPModelUtils.getDocBlock(typeField[0])) != null) {
                                docs.put(docBlock, typeField[0]);
                            }
                            ++n4;
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block22;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        for (PHPDocBlock doc : docs.keySet()) {
            IField typeField = (IField)docs.get((Object)doc);
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)typeField);
            PHPDocTag[] pHPDocTagArray = doc.getTags();
            int n = pHPDocTagArray.length;
            int n5 = 0;
            while (n5 < n) {
                PHPDocTag tag = pHPDocTagArray[n5];
                if (tag.getTagKind() == 12) {
                    SimpleReference[] references;
                    SimpleReference[] simpleReferenceArray = references = tag.getReferences();
                    int n6 = references.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        SimpleReference ref = simpleReferenceArray[n7];
                        String typeName = ref.getName();
                        Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
                        if (m.find()) {
                            this.evaluated.add((IEvaluatedType)PHPDocClassVariableEvaluator.getArrayType(m.group(), currentNamespace, doc.sourceStart()));
                        } else if (typeName.endsWith(BRACKETS) && typeName.length() > 2) {
                            int offset = 0;
                            try {
                                offset = typeField.getSourceRange().getOffset();
                            }
                            catch (ModelException modelException) {}
                            this.evaluated.add((IEvaluatedType)PHPDocClassVariableEvaluator.getArrayType(typeName.substring(0, typeName.length() - 2), currentNamespace, offset));
                        } else {
                            IEvaluatedType type;
                            if (currentNamespace != null) {
                                String fullName;
                                Map<String, UsePart> result;
                                String prefix;
                                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                                if (typeName.indexOf(SPLASH) > 0) {
                                    prefix = typeName.substring(0, typeName.indexOf(SPLASH));
                                    result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, doc.sourceStart(), currentNamespace, true);
                                    if (result.containsKey(prefix) && (typeName = typeName.replace(prefix, fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                                        typeName = String.valueOf('\\') + typeName;
                                    }
                                } else if (typeName.indexOf(SPLASH) < 0 && (result = PHPModelUtils.getAliasToNSMap(prefix = typeName, moduleDeclaration, doc.sourceStart(), currentNamespace, true)).containsKey(prefix) && (typeName = (fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                                    typeName = String.valueOf('\\') + typeName;
                                }
                            }
                            if ((type = PHPDocClassVariableEvaluator.getEvaluatedType(typeName, currentNamespace)) != null) {
                                this.evaluated.add(type);
                            }
                        }
                        ++n7;
                    }
                }
                ++n5;
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    public static MultiTypeType getArrayType(String type, IType currentNamespace, int offset) {
        String[] typeNames;
        int beginIndex = type.indexOf("[") + 1;
        int endIndex = type.lastIndexOf("]");
        if (endIndex != -1) {
            type = type.substring(beginIndex, endIndex);
        }
        MultiTypeType arrayType = new MultiTypeType();
        Matcher m = ARRAY_TYPE_PATTERN.matcher(type);
        if (m.find()) {
            arrayType.addType((IEvaluatedType)PHPDocClassVariableEvaluator.getArrayType(m.group(), currentNamespace, offset));
            type = m.replaceAll("");
        }
        String[] stringArray = typeNames = type.split(",");
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!"".equals(name)) {
                if (name.indexOf(92) > 0 && currentNamespace != null) {
                    String fullName;
                    ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                    String prefix = name.substring(0, name.indexOf(92));
                    Map<String, UsePart> result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, currentNamespace, true);
                    if (result.containsKey(prefix) && (name = name.replace(prefix, fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                        name = String.valueOf('\\') + name;
                    }
                }
                arrayType.addType(PHPDocClassVariableEvaluator.getEvaluatedType(name, currentNamespace));
            }
            ++n2;
        }
        return arrayType;
    }

    public static IEvaluatedType getEvaluatedType(String typeName, IType currentNamespace) {
        Object type = PHPSimpleTypes.fromString(typeName);
        if (type == null) {
            if (typeName.indexOf(92) > 0 && currentNamespace != null) {
                typeName = String.valueOf('\\') + currentNamespace.getElementName() + '\\' + typeName;
            }
            if (typeName.indexOf(92) != -1 || currentNamespace == null) {
                type = new PHPClassType(typeName);
            } else if (currentNamespace != null) {
                type = new PHPClassType(currentNamespace.getElementName(), typeName);
            }
        }
        return type;
    }
}

