/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPRuntime;
import org.eclipse.php.internal.debug.core.launching.DebugSessionIdGenerator;
import org.eclipse.php.internal.debug.core.launching.PHPLaunch;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPExecutableDebuggerInitializer;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPExecutableLaunchDelegate
extends LaunchConfigurationDelegate {
    public static final String SAVE_AUTOMATICALLY = "save_automatically";
    protected Map<String, String> envVariables = null;

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PHPLaunch(configuration, mode, null);
    }

    public void debugPHPExecutable(ILaunch launch, String phpExe, String fileToDebug) throws DebugException {
        try {
            launch.setAttribute("executable_launch", Boolean.toString(true));
            IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(launch);
            PHPExecutableDebuggerInitializer debuggerInitializer = new PHPExecutableDebuggerInitializer(launch);
            String phpExeString = new File(phpExe).getAbsolutePath();
            String fileName = new File(fileToDebug).getAbsolutePath();
            String query = PHPLaunchUtilities.generateQuery(launch, parametersInitializer);
            String iniFileLocation = launch.getAttribute("PHPIniLocation");
            String workingDir = new File(fileToDebug).getParentFile().getAbsolutePath();
            debuggerInitializer.initializeDebug(phpExeString, fileName, workingDir, query, this.envVariables, iniFileLocation);
        }
        catch (IOException e1) {
            Logger.logException("PHPDebugTarget: Debugger didn't find file to debug.", e1);
            String errorMessage = PHPDebugCoreMessages.DebuggerFileNotFound_1;
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, (Throwable)e1));
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        PHPexeItem item;
        PHPVersion version;
        if (!DaemonPlugin.getDefault().validateCommunicationDaemons("org.eclipse.php.debug.core.zendDebugger")) {
            monitor.setCanceled(true);
            monitor.done();
            return;
        }
        if (!PHPLaunchUtilities.notifyPreviousLaunches(launch)) {
            monitor.setCanceled(true);
            monitor.done();
            return;
        }
        PHPLaunchUtilities.showDebugView();
        if (monitor.isCanceled()) {
            return;
        }
        String path = configuration.getAttribute("org.eclipse.php.debug.core.PHP_CONTAINER", null);
        if (path != null && (version = PHPRuntime.getPHPVersion(Path.fromPortableString((String)path))) != null && (item = PHPDebugPlugin.getPHPexeItem(version)) != null) {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            workingCopy.setAttribute("ATTR_LOCATION", item.getExecutable().toString());
            workingCopy.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, item.getDebuggerID());
            if (item.getINILocation() != null) {
                workingCopy.setAttribute("ATTR_INI_LOCATION", item.getINILocation().toString());
            } else {
                workingCopy.setAttribute("ATTR_INI_LOCATION", null);
            }
            configuration = workingCopy.doSave();
        }
        String phpExeString = configuration.getAttribute("ATTR_LOCATION", null);
        String phpIniPath = configuration.getAttribute("ATTR_INI_LOCATION", null);
        String fileName = configuration.getAttribute("ATTR_FILE_FULL_PATH", null);
        boolean runWithDebugInfo = configuration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        IProject project = null;
        String file = configuration.getAttribute("ATTR_FILE", null);
        if (file != null) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(file);
            if (resource != null) {
                project = resource.getProject();
            } else {
                IProject resolved;
                String projectName = configuration.getAttribute("ATTR_PROJECT_NAME", null);
                if (projectName != null && (resolved = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && resolved.isAccessible()) {
                    project = resolved;
                }
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (fileName == null || fileName.equals("")) {
            this.displayErrorMessage(PHPDebugCoreMessages.PHPExecutableLaunchDelegate_0);
            return;
        }
        if (phpExeString == null) {
            this.displayErrorMessage(PHPDebugCoreMessages.PHPExecutableLaunchDelegate_4);
            return;
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        File phpIni = phpIniPath != null && new File(phpIniPath).exists() ? new File(phpIniPath) : PHPINIUtil.findPHPIni(phpExeString);
        File tempIni = PHPINIUtil.prepareBeforeDebug(phpIni, phpExeString, project);
        launch.setAttribute("PHPIniLocation", tempIni.getAbsolutePath());
        if (mode.equals("debug") || runWithDebugInfo) {
            boolean stopAtFirstLine = configuration.getAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine(project));
            int requestPort = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
            ILaunchConfigurationWorkingCopy wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            if (project != null) {
                wc.setAttribute("org.eclipse.php.debug.core.PHP_Project", project.getFullPath().toString());
            }
            wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(project));
            wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(project));
            wc.setAttribute("php_debug_type", "php_exe_script_debug");
            wc.doSave();
            if (monitor.isCanceled()) {
                return;
            }
            int sessionID = DebugSessionIdGenerator.generateSessionID();
            PHPSessionLaunchMapper.put(sessionID, launch);
            launch.setAttribute("port", Integer.toString(requestPort));
            launch.setAttribute("firstLineBreakpoint", Boolean.toString(stopAtFirstLine));
            launch.setAttribute("debugSessionID", Integer.toString(sessionID));
            this.debugPHPExecutable(launch, phpExeString, fileName);
        } else {
            PHPexeItem[] items;
            Path phpExe = new Path(phpExeString);
            String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
            File phpExeFile = new File(phpExeString);
            String phpIniLocation = launch.getAttribute("PHPIniLocation");
            String phpConfigDir = phpExeFile.getParent();
            if (phpIniLocation != null && !phpIniLocation.equals("")) {
                phpConfigDir = new File(phpIniLocation).getParent();
            }
            String sapiType = null;
            String phpV = null;
            PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem item2 = pHPexeItemArray[n2];
                if (item2.getExecutable().equals(phpExeFile)) {
                    sapiType = item2.getSapiType();
                    phpV = item2.getVersion();
                    break;
                }
                ++n2;
            }
            String[] args = PHPLaunchUtilities.getProgramArguments(launch.getLaunchConfiguration());
            String[] cmdLine = PHPLaunchUtilities.getCommandLine(launch.getLaunchConfiguration(), phpExeString, phpConfigDir, fileName, (String[])(sapiType == "CLI" ? args : null), phpV);
            String libPath = PHPLaunchUtilities.getLibrarySearchPathEnv(phpExeFile.getParentFile());
            if (libPath != null) {
                String[] envpNew = new String[envp == null ? 1 : envp.length + 1];
                if (envp != null) {
                    System.arraycopy(envp, 0, envpNew, 0, envp.length);
                }
                envpNew[envpNew.length - 1] = libPath;
                envp = envpNew;
            }
            if (monitor.isCanceled()) {
                return;
            }
            File workingDir = new File(fileName).getParentFile();
            Process p = workingDir.exists() ? DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp) : DebugPlugin.exec((String[])cmdLine, null, (String[])envp);
            new Thread(new ProcessCrashDetector(launch, p)).start();
            IProcess process = null;
            HashMap<String, String> processAttributes = new HashMap<String, String>();
            String programName = phpExe.lastSegment();
            String extension = phpExe.getFileExtension();
            if (extension != null) {
                programName = programName.substring(0, programName.length() - (extension.length() + 1));
            }
            programName = programName.toLowerCase();
            processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
            if (p != null) {
                subMonitor = new SubProgressMonitor(monitor, 80);
                subMonitor.beginTask(MessageFormat.format((String)"start launch", (Object[])new Object[]{configuration.getName()}), -1);
                process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)phpExe.toOSString(), processAttributes);
                if (process == null) {
                    p.destroy();
                    throw new CoreException((IStatus)new Status(4, PHPDebugPlugin.getID(), 0, null, null));
                }
                subMonitor.done();
            }
            process.setAttribute(IProcess.ATTR_CMDLINE, fileName);
            if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
                while (!process.isTerminated()) {
                    try {
                        if (monitor.isCanceled()) {
                            process.terminate();
                            break;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                subMonitor = new SubProgressMonitor(monitor, 10);
                RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)subMonitor);
            }
        }
    }

    private void displayErrorMessage(final String message) {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Debugger_LaunchError_title, (String)message);
            }
        });
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String filePath = configuration.getAttribute("ATTR_FILE", "");
        if ("".equals(filePath)) {
            return super.saveBeforeLaunch(configuration, mode, monitor);
        }
        return super.saveBeforeLaunch(configuration, mode, monitor);
    }
}

