/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.viewsupport.SourcePositionSorter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SortAction
extends Action {
    public static final String PREF_IS_SORTED = "SortingAction.isChecked";
    private TreeViewer treeViewer;
    private ModelElementSorter fComparator = new ModelElementSorter(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof PHPOutlineContentProvider.UseStatementsNode) {
                return -1;
            }
            if (e2 instanceof PHPOutlineContentProvider.UseStatementsNode) {
                return 1;
            }
            return super.compare(viewer, e1, e2);
        }
    };
    private SourcePositionSorter fSourcePositonComparator = new SourcePositionSorter();

    public SortAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.help.outline_view");
        this.setText(PHPUIMessages.PHPOutlinePage_Sort_label);
        PHPPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
        this.setToolTipText(PHPUIMessages.PHPOutlinePage_Sort_tooltip);
        this.setDescription(PHPUIMessages.PHPOutlinePage_Sort_description);
        boolean checked = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean(PREF_IS_SORTED);
        this.valueChanged(checked, false);
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(final boolean on, boolean store) {
        this.setChecked(on);
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (on) {
                    SortAction.this.treeViewer.setComparator((ViewerComparator)SortAction.this.fComparator);
                } else {
                    SortAction.this.treeViewer.setComparator((ViewerComparator)SortAction.this.fSourcePositonComparator);
                }
            }
        });
        if (store) {
            PHPUiPlugin.getDefault().getPreferenceStore().setValue(PREF_IS_SORTED, on);
        }
    }
}

