/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighter.ModelUtils;
import org.eclipse.php.internal.ui.editor.highlighters.AbstractSemanticApplyWithNS;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;
import org.eclipse.swt.graphics.RGB;

public class InternalClassHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new InternalClassApply(this.getSourceModule());
    }

    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false).setDefaultTextColor(new RGB(0, 0, 192));
    }

    public String getDisplayName() {
        return Messages.InternalClassHighlighting_0;
    }

    public int getPriority() {
        return 110;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InternalClassApply
    extends AbstractSemanticApplyWithNS {
        public InternalClassApply(ISourceModule sourceModule) {
            super(sourceModule);
        }

        public boolean visit(CatchClause catchStatement) {
            Expression className = catchStatement.getClassName();
            if (className instanceof Identifier) {
                this.dealIdentifier((Identifier)className);
            }
            return true;
        }

        public boolean visit(StaticConstantAccess staticDispatch) {
            Expression className = staticDispatch.getClassName();
            if (className instanceof Identifier) {
                this.dealIdentifier((Identifier)className);
            }
            return false;
        }

        public boolean visit(StaticFieldAccess staticDispatch) {
            Expression className = staticDispatch.getClassName();
            if (className instanceof Identifier) {
                this.dealIdentifier((Identifier)className);
            }
            return false;
        }

        public boolean visit(StaticMethodInvocation staticDispatch) {
            Expression className = staticDispatch.getClassName();
            if (className instanceof Identifier) {
                this.dealIdentifier((Identifier)className);
            }
            return true;
        }

        public boolean visit(ClassName className) {
            if (className.getName() instanceof Identifier) {
                Identifier identifier = (Identifier)className.getName();
                this.dealIdentifier(identifier);
            }
            return false;
        }

        public boolean visit(ClassDeclaration classDeclaration) {
            this.checkSuper(classDeclaration.getSuperClass(), classDeclaration.interfaces());
            return true;
        }

        private void checkSuper(Expression superClass, List<Identifier> interfaces) {
            if (superClass instanceof Identifier) {
                this.dealIdentifier((Identifier)superClass);
            }
            if (interfaces != null) {
                for (Identifier identifier : interfaces) {
                    this.dealIdentifier(identifier);
                }
            }
        }

        private void dealIdentifier(Identifier identifier) {
            String fullName = AbstractOccurrencesFinder.getFullName((Identifier)identifier, (Map)this.fLastUseParts, (NamespaceDeclaration)this.fCurrentNamespace);
            IType[] elements = PhpModelAccess.getDefault().findTypes(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, this.createSearchScope(), null);
            if (elements != null && elements.length == 1 && elements[0] != null && ModelUtils.isExternalElement((IModelElement)elements[0])) {
                InternalClassHighlighting.this.highlight((ASTNode)identifier);
            }
        }
    }
}

