/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.FileContext;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class MethodHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new MethodApply();
    }

    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false);
    }

    public String getDisplayName() {
        return Messages.MethodHighlighting_0;
    }

    protected class MethodApply
    extends AbstractSemanticApply {
        protected MethodApply() {
        }

        public boolean visit(MethodDeclaration classMethodDeclaration) {
            Identifier functionName = classMethodDeclaration.getFunction().getFunctionName();
            MethodHighlighting.this.highlight((ASTNode)functionName);
            return true;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            this.checkDispatch((ASTNode)methodInvocation.getMethod().getFunctionName().getName());
            return true;
        }

        private void checkDispatch(ASTNode node) {
            if (node.getType() == 33) {
                MethodHighlighting.this.highlight(node);
            }
            if (node.getType() == 60) {
                Variable id = (Variable)node;
                this.checkDispatch((ASTNode)id.getName());
            }
        }

        public boolean visit(TraitUseStatement node) {
            ISourceModule sourceModule = MethodHighlighting.this.getSourceModule();
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
            FileContext context = new FileContext(sourceModule, moduleDeclaration, node.getStart());
            List tsList = node.getTsList();
            block6: for (TraitStatement traitStatement : tsList) {
                IModelElement iModelElement;
                int n;
                IModelElement[] iModelElementArray;
                boolean shouldBreak;
                IType iType;
                int n2;
                int n3;
                IType[] iTypeArray;
                IType[] modelElements;
                PHPClassType type;
                FullyQualifiedTraitMethodReference reference;
                TraitAliasStatement statement;
                if (traitStatement instanceof TraitAliasStatement) {
                    statement = (TraitAliasStatement)traitStatement;
                    if (statement.getAlias().getTraitMethod() instanceof FullyQualifiedTraitMethodReference) {
                        reference = (FullyQualifiedTraitMethodReference)statement.getAlias().getTraitMethod();
                        type = PHPClassType.fromTraitName((String)PHPModelUtils.getFullName((NamespaceName)reference.getClassName()), (ISourceModule)sourceModule, (int)traitStatement.getStart());
                        modelElements = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)type, (ISourceModuleContext)context, (int)traitStatement.getStart());
                        if (modelElements == null || modelElements.length <= 0) continue;
                        iTypeArray = modelElements;
                        n3 = modelElements.length;
                        n2 = 0;
                        while (n2 < n3) {
                            iType = iTypeArray[n2];
                            shouldBreak = false;
                            try {
                                IModelElement[] children;
                                iModelElementArray = children = iType.getChildren();
                                n = children.length;
                                int n4 = 0;
                                while (n4 < n) {
                                    iModelElement = iModelElementArray[n4];
                                    if (iModelElement.getElementName().equals(reference.getFunctionName().getName()) && iModelElement instanceof IMethod) {
                                        MethodHighlighting.this.highlight((ASTNode)reference.getFunctionName());
                                        shouldBreak = true;
                                        break;
                                    }
                                    ++n4;
                                }
                            }
                            catch (ModelException e) {
                                e.printStackTrace();
                            }
                            if (shouldBreak) continue block6;
                            ++n2;
                        }
                        continue;
                    }
                    Identifier method = (Identifier)statement.getAlias().getTraitMethod();
                    List traitList = node.getTraitList();
                    for (NamespaceName namespaceName : traitList) {
                        boolean shouldBreak2 = false;
                        PHPClassType type2 = PHPClassType.fromTraitName((String)PHPModelUtils.getFullName((NamespaceName)namespaceName), (ISourceModule)sourceModule, (int)traitStatement.getStart());
                        IType[] modelElements2 = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)type2, (ISourceModuleContext)context, (int)traitStatement.getStart());
                        if (modelElements2 != null && modelElements2.length > 0) {
                            IType[] iTypeArray2 = modelElements2;
                            int iModelElement2 = modelElements2.length;
                            int e = 0;
                            while (e < iModelElement2) {
                                IType iType2 = iTypeArray2[e];
                                try {
                                    IModelElement[] children;
                                    IModelElement[] iModelElementArray2 = children = iType2.getChildren();
                                    int n5 = children.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IModelElement iModelElement3 = iModelElementArray2[n6];
                                        if (iModelElement3.getElementName().equals(method.getName()) && iModelElement3 instanceof IMethod) {
                                            MethodHighlighting.this.highlight((ASTNode)method);
                                            shouldBreak2 = true;
                                            break;
                                        }
                                        ++n6;
                                    }
                                }
                                catch (ModelException e2) {
                                    e2.printStackTrace();
                                }
                                if (shouldBreak2) break;
                                ++e;
                            }
                        }
                        if (shouldBreak2) continue block6;
                    }
                    continue;
                }
                if (!(traitStatement instanceof TraitPrecedenceStatement) || (modelElements = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)(type = PHPClassType.fromTraitName((String)PHPModelUtils.getFullName((NamespaceName)(reference = (statement = (TraitPrecedenceStatement)traitStatement).getPrecedence().getMethodReference()).getClassName()), (ISourceModule)sourceModule, (int)traitStatement.getStart())), (ISourceModuleContext)context, (int)traitStatement.getStart())) == null || modelElements.length <= 0) continue;
                iTypeArray = modelElements;
                n3 = modelElements.length;
                n2 = 0;
                while (n2 < n3) {
                    iType = iTypeArray[n2];
                    shouldBreak = false;
                    try {
                        IModelElement[] children;
                        iModelElementArray = children = iType.getChildren();
                        n = children.length;
                        int n7 = 0;
                        while (n7 < n) {
                            iModelElement = iModelElementArray[n7];
                            if (iModelElement.getElementName().equals(reference.getFunctionName().getName()) && iModelElement instanceof IMethod) {
                                MethodHighlighting.this.highlight((ASTNode)reference.getFunctionName());
                                shouldBreak = true;
                                break;
                            }
                            ++n7;
                        }
                    }
                    catch (ModelException e) {
                        e.printStackTrace();
                    }
                    if (shouldBreak) continue block6;
                    ++n2;
                }
            }
            return false;
        }
    }
}

