/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.internal.rdt.sync.core.services.SynchronizeServiceRegistry;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.handlers.IMissingConnectionHandler;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeService;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;

public class SyncConfig
implements Comparable<SyncConfig> {
    private String fName;
    private String fSyncProviderId;
    private String fConnectionName;
    private String fRemoteServicesId;
    private String fLocation;
    private IProject fProject;
    private boolean fSyncOnPreBuild = true;
    private boolean fSyncOnPostBuild = true;
    private boolean fSyncOnSave = true;
    private final Map<String, String> fProperties = new HashMap<String, String>();
    private IRemoteServices fRemoteServices;
    private IRemoteConnection fRemoteConnection;
    private ISynchronizeService fSyncService;

    public static String resolveString(IProject project, String path) {
        if (!path.startsWith("${") || !path.endsWith("}")) {
            return path;
        }
        String newPath = path.substring(2, path.length() - 1);
        String variable = newPath.split(":")[0];
        IPathVariableManager pvm = project.getPathVariableManager();
        String value = pvm.getURIValue(variable.toUpperCase()).toString();
        if (value == null) {
            return path;
        }
        if ((value = value.replaceFirst("file:", "")).endsWith("/") || value.endsWith("\\")) {
            value = value.substring(0, path.length() - 1);
        }
        return newPath.replaceFirst(String.valueOf(variable) + ":*", value);
    }

    public SyncConfig(String name) {
        this.fName = name;
    }

    @Override
    public int compareTo(SyncConfig config) {
        return this.getName().compareTo(config.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyncConfig other = (SyncConfig)obj;
        return this.fName.equals(other.fName);
    }

    public String getConnectionName() {
        return this.fConnectionName;
    }

    public String[] getKeys() {
        return this.fProperties.keySet().toArray(new String[0]);
    }

    public String getLocation() {
        return this.fLocation;
    }

    public String getLocation(IProject project) {
        return SyncConfig.resolveString(project, this.fLocation);
    }

    public String getName() {
        return this.fName;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getProperty(String key) {
        return this.fProperties.get(key);
    }

    public IRemoteConnection getRemoteConnection() throws MissingConnectionException {
        if (this.fRemoteServices == null) {
            this.fRemoteServices = RemoteServices.getRemoteServices((String)this.fRemoteServicesId);
            this.fRemoteConnection = null;
        }
        if (this.fRemoteConnection == null) {
            IMissingConnectionHandler mcHandler;
            this.fRemoteConnection = this.fRemoteServices.getConnectionManager().getConnection(this.fConnectionName);
            if (this.fRemoteConnection == null && (mcHandler = SyncManager.getDefaultMissingConnectionHandler()) != null) {
                mcHandler.handle(this.fRemoteServices, this.fConnectionName);
                this.fRemoteConnection = this.fRemoteServices.getConnectionManager().getConnection(this.fConnectionName);
            }
        }
        if (this.fRemoteConnection == null) {
            throw new MissingConnectionException(this.fConnectionName);
        }
        return this.fRemoteConnection;
    }

    public String getRemoteServicesId() {
        return this.fRemoteServicesId;
    }

    public String getSyncProviderId() {
        return this.fSyncProviderId;
    }

    public ISynchronizeService getSyncService() {
        if (this.fSyncService == null) {
            this.fSyncService = SynchronizeServiceRegistry.getSynchronizeServiceDescriptor(this.getSyncProviderId()).getService();
            if (this.fSyncService == null) {
                throw new RuntimeException("Unable to locate sync service");
            }
        }
        return this.fSyncService;
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    public boolean isSyncOnPostBuild() {
        return this.fSyncOnPostBuild;
    }

    public boolean isSyncOnPreBuild() {
        return this.fSyncOnPreBuild;
    }

    public boolean isSyncOnSave() {
        return this.fSyncOnSave;
    }

    public void setConfigName(String configName) {
        this.fName = configName;
    }

    public void setConnection(IRemoteConnection connection) {
        this.fRemoteServices = connection.getRemoteServices();
        this.fRemoteServicesId = connection.getRemoteServices().getId();
        this.fConnectionName = connection.getName();
        this.fRemoteConnection = connection;
    }

    public void setConnectionName(String connectionName) {
        this.fConnectionName = connectionName;
        this.fRemoteConnection = null;
    }

    public void setLocation(String location) {
        this.fLocation = location;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void setProperty(String key, String value) {
        this.fProperties.put(key, value);
    }

    public void setRemoteServicesId(String remoteServicesId) {
        this.fRemoteServicesId = remoteServicesId;
        this.fRemoteServices = null;
    }

    public void setSyncOnPostBuild(boolean syncOnPostBuild) {
        this.fSyncOnPostBuild = syncOnPostBuild;
    }

    public void setSyncOnPreBuild(boolean syncOnPreBuild) {
        this.fSyncOnPreBuild = syncOnPreBuild;
    }

    public void setSyncOnSave(boolean syncOnSave) {
        this.fSyncOnSave = syncOnSave;
    }

    public void setSyncProviderId(String syncProviderId) {
        this.fSyncProviderId = syncProviderId;
        this.fSyncService = null;
    }
}

