/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MnemonicsTab
extends ExampleTab {
    private static final String DEFAULT_ACTIVATOR = "CTRL+ALT";
    private static final String[] DEFAULT_SHORTCUT = new String[]{"CTRL+ALT+Y"};
    protected boolean useCTabFolder;

    public MnemonicsTab() {
        super("Mnemonics");
    }

    protected void createStyleControls(Composite parent) {
        this.createActivatorControls(parent);
        this.createShortcutControls(parent);
        this.createCTabFolderButton(parent);
    }

    private void createShortcutControls(Composite parent) {
        final Display display = parent.getDisplay();
        display.setData("org.eclipse.rap.rwt.activeKeys", (Object)DEFAULT_SHORTCUT);
        display.setData("org.eclipse.rap.rwt.cancelKeys", (Object)DEFAULT_SHORTCUT);
        final Text shortcutText = new Text(parent, 2048);
        shortcutText.setText(DEFAULT_SHORTCUT[0]);
        shortcutText.setLayoutData((Object)new RowData(110, -1));
        Button setShortcut = new Button(parent, 8);
        setShortcut.setText("Set global shortcut");
        setShortcut.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String[] shortcut = new String[]{shortcutText.getText()};
                display.setData("org.eclipse.rap.rwt.activeKeys", (Object)shortcut);
                display.setData("org.eclipse.rap.rwt.cancelKeys", (Object)shortcut);
            }
        });
        display.addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                MnemonicsTab.this.log(event.toString());
            }
        });
    }

    private void createActivatorControls(Composite parent) {
        final Display display = parent.getDisplay();
        display.setData("org.eclipse.rap.rwt.mnemonicActivator", (Object)DEFAULT_ACTIVATOR);
        final Text activatorText = new Text(parent, 2048);
        activatorText.setText(DEFAULT_ACTIVATOR);
        activatorText.setLayoutData((Object)new RowData(110, -1));
        Button setActivator = new Button(parent, 8);
        setActivator.setText("Set activator");
        setActivator.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                display.setData("org.eclipse.rap.rwt.mnemonicActivator", (Object)activatorText.getText());
            }
        });
    }

    private void createCTabFolderButton(Composite parent) {
        final Button ctabFolderButton = new Button(parent, 2);
        ctabFolderButton.setText("Use CTabFolder");
        ctabFolderButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MnemonicsTab.this.useCTabFolder = ctabFolderButton.getSelection();
                MnemonicsTab.this.createNew();
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        int tabCount = 4;
        if (this.useCTabFolder) {
            CTabFolder folder = new CTabFolder(parent, this.getStyle());
            CTabItem[] tabItems = new CTabItem[tabCount];
            int i = 0;
            while (i < tabCount) {
                tabItems[i] = new CTabItem(folder, 0);
                tabItems[i].setText("CTabItem &" + (i + 1));
                Composite content = this.createItemContent((Composite)folder, i);
                tabItems[i].setControl((Control)content);
                ++i;
            }
            folder.setSelection(0);
        } else {
            TabFolder folder = new TabFolder(parent, this.getStyle());
            TabItem[] tabItems = new TabItem[tabCount];
            int i = 0;
            while (i < tabCount) {
                tabItems[i] = new TabItem(folder, 0);
                tabItems[i].setText("TabItem &" + (i + 1));
                Composite content = this.createItemContent((Composite)folder, i);
                tabItems[i].setControl((Control)content);
                ++i;
            }
        }
    }

    private Composite createItemContent(Composite folder, int index) {
        Composite content = new Composite(folder, 0);
        content.setLayout((Layout)new GridLayout(4, false));
        switch (index) {
            case 0: {
                this.createButtonExample(content);
                break;
            }
            case 1: {
                this.createToolBarExample(content);
                this.createLabelExample(content);
                break;
            }
            case 2: {
                this.createGroupExample(content);
                break;
            }
            case 3: {
                this.createMenuExample(content);
            }
        }
        return content;
    }

    private void createMenuExample(final Composite content) {
        Button button = new Button(content, 8);
        button.setText("Open Shell with Menu");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MnemonicsTab.this.createShellWithMenu(content);
            }
        });
    }

    private void createShellWithMenu(Composite content) {
        final Shell shell = new Shell(content.getShell(), 2048);
        shell.setLayout((Layout)new GridLayout());
        this.createMenuBar(shell);
        Button closeButton = new Button((Composite)shell, 8);
        closeButton.setText("Close");
        closeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        shell.setLocation(content.toDisplay(0, 0));
        shell.setSize(content.getSize());
        shell.open();
        content.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
    }

    private void createMenuBar(final Shell shell) {
        String[] items = new String[]{"&File", "&Edit", "&Lazy", "E&xit"};
        Menu bar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(bar);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            MenuItem menuItem = new MenuItem(bar, 64);
            menuItem.setText(text);
            Menu dropdown = new Menu((Decorations)shell, 4);
            menuItem.setMenu(dropdown);
            ++n2;
        }
        MenuItem pushOne = this.createMenuItem(bar.getItem(0).getMenu(), 8, "Push &One\tCtrl+Shift+1");
        pushOne.setAccelerator(393265);
        MenuItem pushTwo = this.createMenuItem(bar.getItem(0).getMenu(), 8, "Push &Two\tCtrl+Shift+2");
        pushTwo.setAccelerator(393266);
        MenuItem check = this.createMenuItem(bar.getItem(0).getMenu(), 32, "&Check\tCtrl+C");
        check.setAccelerator(262211);
        this.createMenuItem(bar.getItem(0).getMenu(), 2, "Separator &W");
        this.createMenuItem(bar.getItem(0).getMenu(), 16, "Radio &X");
        this.createMenuItem(bar.getItem(0).getMenu(), 16, "Radio &Y");
        this.createMenuItem(bar.getItem(0).getMenu(), 16, "Radio &Z");
        this.createMenuItem(bar.getItem(1).getMenu(), 8, "Push &Three");
        MenuItem casc = this.createMenuItem(bar.getItem(1).getMenu(), 64, "&Submenu");
        Menu submenu = new Menu((Decorations)shell, 4);
        casc.setMenu(submenu);
        this.createMenuItem(submenu, 32, "Ch&eck");
        this.createMenuItem(submenu, 16, "Radio &8");
        this.createMenuItem(submenu, 16, "Radio &9");
        this.createMenuItem(bar.getItem(2).getMenu(), 8, "Default &Item");
        this.crateLazyMenu(bar.getItem(2));
        MenuItem close = this.createMenuItem(bar.getItem(3).getMenu(), 8, "Close &Shell");
        close.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
    }

    private void crateLazyMenu(MenuItem item) {
        final Menu menu = item.getMenu();
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                menu.getItem(0).dispose();
                MnemonicsTab.this.createMenuItem(menu, 8, "&Generated Item");
            }
        });
    }

    private MenuItem createMenuItem(Menu menu, int style, String text) {
        final MenuItem item = new MenuItem(menu, style);
        item.setText(text);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MnemonicsTab.this.log(item.getText());
            }
        });
        return item;
    }

    private void createButtonExample(Composite content) {
        this.createButton(content, 8, "Push &One");
        this.createButton(content, 8, "Push &Two");
        this.createButton(content, 2, "To&ggle");
        this.createButton(content, 32, "&Checkbox");
        this.createButton(content, 16, "Radio &X");
        this.createButton(content, 16, "Radio &Y");
        this.createButton(content, 16, "Radio &Z");
    }

    private void createToolBarExample(Composite content) {
        Label label = new Label(content, 0);
        label.setText("ToolBar:");
        ToolBar bar = new ToolBar(content, 2048);
        this.createToolItem(bar, 8, "Push &Three");
        this.createToolItem(bar, 32, "Toggl&e");
        this.createToolItem(bar, 16, "Radio &8");
        this.createToolItem(bar, 16, "Radio &9");
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        bar.setLayoutData((Object)layoutData);
    }

    private void createGroupExample(Composite content) {
        content.setLayout((Layout)new GridLayout(3, false));
        Group groupA = new Group(content, 4);
        groupA.setText("Group &A");
        groupA.setLayout((Layout)new GridLayout());
        groupA.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createText((Composite)groupA);
        Group groupB = new Group(content, 4);
        groupB.setText("Group &B with Composite");
        groupB.setLayoutData((Object)new GridData(4, 4, false, false));
        groupB.setLayout((Layout)new FillLayout());
        Composite comp = new Composite((Composite)groupB, 2048);
        comp.setLayout((Layout)new GridLayout());
        this.createText(comp);
        Group groupC = new Group(content, 4);
        groupC.setText("Group &C");
        groupC.setLayout((Layout)new GridLayout());
        groupC.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createText((Composite)groupC).setEnabled(false);
        this.createText((Composite)groupC).setVisible(false);
        this.createText((Composite)groupC);
    }

    private void createLabelExample(Composite content) {
        Label label = new Label(content, 0);
        label.setText("L&abel:");
        this.createText(content);
        CLabel clabel = new CLabel(content, 0);
        clabel.setText("&CLabel:");
        Button button = new Button(content, 32);
        button.setText("Button");
        Label labelForDisabled = new Label(content, 0);
        labelForDisabled.setText("D&isabled:");
        this.createText(content).setEnabled(false);
        Label labelForInvisible = new Label(content, 0);
        labelForInvisible.setText("In&visible:");
        this.createText(content).setVisible(false);
    }

    private Text createText(Composite content) {
        Text text = new Text(content, 2048);
        text.setText("Text");
        return text;
    }

    private void createButton(Composite content, int style, String text) {
        final Button button = new Button(content, style);
        button.setText(text);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MnemonicsTab.this.log(button.getText());
            }
        });
    }

    private void createToolItem(ToolBar bar, int style, String text) {
        final ToolItem item = new ToolItem(bar, style);
        item.setText(text);
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MnemonicsTab.this.log(item.getText());
            }
        });
    }
}

