/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rap.examples.IExampleContribution;
import org.eclipse.rap.examples.internal.Activator;
import org.eclipse.rap.examples.internal.ExampleCategory;
import org.eclipse.rap.examples.internal.ExampleContributionsTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Examples {
    private static final List<ExampleCategory> EXAMPLE_CATEGORIES = Examples.createCategories();

    private Examples() {
    }

    public static Examples getInstance() {
        return new Examples();
    }

    public List<ExampleCategory> getCategories() {
        return Collections.unmodifiableList(EXAMPLE_CATEGORIES);
    }

    public IExampleContribution getContribution(String id) {
        return Examples.getContributionsTracker().getContribution(id);
    }

    public IExampleContribution findInitialContribution() {
        IExampleContribution contribution = null;
        List<ExampleCategory> categories = Examples.getInstance().getCategories();
        if (!categories.isEmpty()) {
            contribution = Examples.getFirstContribution(categories.get(0));
        }
        return contribution;
    }

    private static IExampleContribution getFirstContribution(ExampleCategory category) {
        IExampleContribution contribution = null;
        List<String> contributionIds = category.getContributionIds();
        if (!contributionIds.isEmpty()) {
            contribution = Examples.getInstance().getContribution(contributionIds.get(0));
        }
        return contribution;
    }

    private static ExampleContributionsTracker getContributionsTracker() {
        return Activator.getDefault().getExampleContributions();
    }

    private static List<ExampleCategory> createCategories() {
        ArrayList<ExampleCategory> exampleCategories = new ArrayList<ExampleCategory>();
        exampleCategories.add(Examples.createCategory("Basic Widgets", "input", "button", "canvas", "dialog"));
        exampleCategories.add(Examples.createCategory("Trees & Tables", "tableviewer", "treeviewer", "table-markup"));
        exampleCategories.add(Examples.createCategory("Key Features", "complex-data", "rich-label", "validation", "drag-and-drop", "file-upload"));
        exampleCategories.add(Examples.createCategory("Layouts", "grid-layout", "row-layout", "fill-layout"));
        exampleCategories.add(Examples.createCategory("Custom Widgets", "gmaps", "ckeditor", "oscilloscope", "carousel", "chart"));
        return exampleCategories;
    }

    private static ExampleCategory createCategory(String name, String ... contributions) {
        ExampleCategory exampleCategory = new ExampleCategory(name);
        String[] stringArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            String contribution = stringArray[n2];
            exampleCategory.addContributionId(contribution);
            ++n2;
        }
        return exampleCategory;
    }
}

