/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal.service;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.SettingStore;
import org.eclipse.rap.rwt.service.SettingStoreEvent;
import org.eclipse.rap.rwt.service.SettingStoreListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemorySettingStore
implements SettingStore {
    private static final Map<String, String> VALUES = new HashMap<String, String>();
    private static final Set<SettingStoreListener> LISTENERS = new HashSet<SettingStoreListener>();
    private String id;

    public MemorySettingStore(String id) {
        ParamCheck.notNullOrEmpty((String)id, (String)"id");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public synchronized void loadById(String id) {
        ParamCheck.notNullOrEmpty((String)id, (String)"id");
        this.fakeRemoval();
        this.id = id;
        this.loadAttributes();
    }

    public synchronized String getAttribute(String name) {
        ParamCheck.notNull((Object)name, (String)"name");
        String key = String.valueOf(this.id) + name;
        return VALUES.get(key);
    }

    public synchronized Enumeration<String> getAttributeNames() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> iterator = VALUES.keySet().iterator();
        int nameBeginIndex = this.id.length();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith(this.id)) continue;
            result.add(key.substring(nameBeginIndex));
        }
        final Iterator resultIterator = result.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return resultIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)resultIterator.next();
            }
        };
    }

    public synchronized void removeAttribute(String name) {
        ParamCheck.notNull((Object)name, (String)"name");
        String key = String.valueOf(this.id) + name;
        String oldValue = VALUES.remove(key);
        if (oldValue != null) {
            this.notifyListeners(name, oldValue, null);
        }
    }

    public synchronized void setAttribute(String name, String value) {
        ParamCheck.notNull((Object)name, (String)"name");
        if (value == null) {
            this.removeAttribute(name);
        } else {
            ParamCheck.notNull((Object)value, (String)"value");
            String key = String.valueOf(this.id) + name;
            String oldValue = VALUES.put(key, value);
            if (!value.equals(oldValue)) {
                this.notifyListeners(name, oldValue, value);
            }
        }
    }

    public synchronized void addSettingStoreListener(SettingStoreListener listener) {
        ParamCheck.notNull((Object)listener, (String)"listener");
        LISTENERS.add(listener);
    }

    public synchronized void removeSettingStoreListener(SettingStoreListener listener) {
        ParamCheck.notNull((Object)listener, (String)"listener");
        LISTENERS.remove(listener);
    }

    private void fakeRemoval() {
        Enumeration<String> attributes = this.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = attributes.nextElement();
            String key = String.valueOf(this.id) + name;
            String value = VALUES.get(key);
            this.notifyListeners(name, value, null);
        }
    }

    private synchronized void loadAttributes() {
        Enumeration<String> attributes = this.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = attributes.nextElement();
            String key = String.valueOf(this.id) + name;
            String value = VALUES.get(key);
            this.notifyListeners(name, null, value);
        }
    }

    private void log(String msg, Throwable throwable) {
        RWT.getRequest().getSession().getServletContext().log(msg, throwable);
    }

    private synchronized void notifyListeners(String attribute, String oldValue, String newValue) {
        SettingStoreEvent event = new SettingStoreEvent((SettingStore)this, attribute, oldValue, newValue);
        for (SettingStoreListener listener : LISTENERS) {
            String msg;
            try {
                listener.settingChanged(event);
            }
            catch (Exception exc) {
                msg = "Exception when invoking listener " + listener.getClass().getName();
                this.log(msg, exc);
            }
            catch (LinkageError le) {
                msg = "Linkage error when invoking listener " + listener.getClass().getName();
                this.log(msg, le);
            }
        }
    }
}

