/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.client;

import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.client.Client;
import org.eclipse.rap.rwt.client.service.BrowserNavigation;
import org.eclipse.rap.rwt.client.service.ClientInfo;
import org.eclipse.rap.rwt.client.service.ClientService;
import org.eclipse.rap.rwt.client.service.ExitConfirmation;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;
import org.eclipse.rap.rwt.client.service.UrlLauncher;
import org.eclipse.rap.rwt.internal.client.BrowserNavigationImpl;
import org.eclipse.rap.rwt.internal.client.ClientInfoImpl;
import org.eclipse.rap.rwt.internal.client.ClientMessages;
import org.eclipse.rap.rwt.internal.client.ConnectionMessages;
import org.eclipse.rap.rwt.internal.client.ConnectionMessagesImpl;
import org.eclipse.rap.rwt.internal.client.ExitConfirmationImpl;
import org.eclipse.rap.rwt.internal.client.JavaScriptExecutorImpl;
import org.eclipse.rap.rwt.internal.client.JavaScriptLoaderImpl;
import org.eclipse.rap.rwt.internal.client.UrlLauncherImpl;
import org.eclipse.rap.rwt.internal.client.WebClientMessages;
import org.eclipse.rap.rwt.internal.client.WidgetDataWhiteList;
import org.eclipse.rap.rwt.internal.client.WidgetDataWhiteListImpl;
import org.eclipse.rap.rwt.internal.resources.JavaScriptModuleLoader;
import org.eclipse.rap.rwt.internal.resources.JavaScriptModuleLoaderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebClient
implements Client {
    private static final String PREFIX = "org.eclipse.rap.rwt.webclient";
    public static final String THEME_ID = "org.eclipse.rap.rwt.webclient.themeId";
    public static final String HEAD_HTML = "org.eclipse.rap.rwt.webclient.additionalHeaders";
    public static final String BODY_HTML = "org.eclipse.rap.rwt.webclient.bodyHtml";
    public static final String PAGE_TITLE = "org.eclipse.rap.rwt.webclient.pageTitle";
    public static final String FAVICON = "org.eclipse.rap.rwt.webclient.favicon";

    public WebClient() {
        this.initializeServices();
    }

    @Override
    public <T extends ClientService> T getService(Class<T> type) {
        ClientService result = null;
        if (type == JavaScriptExecutor.class) {
            result = this.getServiceImpl(JavaScriptExecutorImpl.class);
        } else if (type == JavaScriptLoader.class) {
            result = this.getServiceImpl(JavaScriptLoaderImpl.class);
        } else if (type == UrlLauncher.class) {
            result = this.getServiceImpl(UrlLauncherImpl.class);
        } else if (type == JavaScriptModuleLoader.class) {
            result = this.getServiceImpl(JavaScriptModuleLoaderImpl.class);
        } else if (type == BrowserNavigation.class) {
            result = this.getServiceImpl(BrowserNavigationImpl.class);
        } else if (type == ExitConfirmation.class) {
            result = this.getServiceImpl(ExitConfirmationImpl.class);
        } else if (type == ConnectionMessages.class) {
            result = this.getServiceImpl(ConnectionMessagesImpl.class);
        } else if (type == WidgetDataWhiteList.class) {
            result = this.getServiceImpl(WidgetDataWhiteListImpl.class);
        } else if (type == ClientInfo.class) {
            result = this.getServiceImpl(ClientInfoImpl.class);
        } else if (type == ClientMessages.class) {
            result = this.getServiceImpl(WebClientMessages.class);
        }
        return (T)result;
    }

    private <T> T getServiceImpl(Class<T> impl) {
        return SingletonUtil.getSessionInstance(impl);
    }

    private void initializeServices() {
        this.getServiceImpl(ClientInfoImpl.class);
    }
}

