/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.Operation;

public class ProtocolMessageWriter {
    private final JsonObject head = new JsonObject();
    private final JsonArray operations = new JsonArray();
    private Operation pendingOperation;
    private boolean alreadyCreated;

    public boolean hasOperations() {
        return this.pendingOperation != null;
    }

    public void appendHead(String property, int value) {
        this.appendHead(property, JsonValue.valueOf(value));
    }

    public void appendHead(String property, String value) {
        this.appendHead(property, JsonValue.valueOf(value));
    }

    public void appendHead(String property, JsonValue value) {
        this.ensureMessagePending();
        this.head.add(property, value);
    }

    public void appendCreate(String target, String type) {
        this.prepareOperation(target, "create", type);
    }

    public void appendSet(String target, String property, int value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, double value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, boolean value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, String value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, JsonValue value) {
        this.prepareOperation(target, "set");
        this.pendingOperation.putProperty(property, value);
    }

    public void appendListen(String target, String eventType, boolean listen) {
        this.prepareOperation(target, "listen");
        this.pendingOperation.putProperty(eventType, JsonValue.valueOf(listen));
    }

    public void appendCall(String target, String methodName, JsonObject parameters) {
        this.prepareOperation(target, "call", methodName, parameters);
    }

    public void appendDestroy(String target) {
        this.prepareOperation(target, "destroy");
    }

    private void prepareOperation(String target, String type) {
        this.prepareOperation(target, type, null, null);
    }

    private void prepareOperation(String target, String type, String detail) {
        this.prepareOperation(target, type, detail, null);
    }

    private void prepareOperation(String target, String type, String detail, JsonObject properties) {
        this.ensureMessagePending();
        if (!this.canAppendToCurrentOperation(target, type)) {
            this.appendPendingOperation();
            this.pendingOperation = new Operation(target, type, detail, properties);
        }
    }

    public JsonObject createMessage() {
        this.ensureMessagePending();
        this.alreadyCreated = true;
        return this.createMessageObject();
    }

    private void ensureMessagePending() {
        if (this.alreadyCreated) {
            throw new IllegalStateException("Message already created");
        }
    }

    private JsonObject createMessageObject() {
        JsonObject message = new JsonObject();
        message.add("head", this.head);
        this.appendPendingOperation();
        message.add("operations", this.operations);
        return message;
    }

    private boolean canAppendToCurrentOperation(String target, String action) {
        boolean result = false;
        if (this.pendingOperation != null && this.pendingOperation.getTarget().equals(target)) {
            String pendingAction = this.pendingOperation.getAction();
            if ("listen".equals(action)) {
                result = pendingAction.equals("listen");
            } else if ("set".equals(action)) {
                result = pendingAction.equals("create") || pendingAction.equals("set");
            }
        }
        return result;
    }

    private void appendPendingOperation() {
        if (this.pendingOperation != null) {
            this.operations.add(this.pendingOperation.toJson());
        }
    }
}

