/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;

class AcceleratorBinding
implements Listener {
    private final MenuItem menuItem;
    private int accelerator;

    AcceleratorBinding(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    public void handleEvent(Event event) {
        if (this.isRelevantEvent(event) && this.menuItem.isEnabled()) {
            this.menuItem.handleAcceleratorActivation();
            event.type = 0;
        }
    }

    int getAccelerator() {
        return this.accelerator;
    }

    void setAccelerator(int accelerator) {
        if (accelerator != this.accelerator) {
            int oldAccelerator = this.accelerator;
            this.accelerator = accelerator;
            if ((this.menuItem.style & 2) == 0) {
                this.updateDisplayActiveKeys(oldAccelerator, accelerator);
                this.updateDisplayFilter(oldAccelerator, accelerator);
            }
        }
    }

    void release() {
        this.setAccelerator(0);
    }

    private boolean isRelevantEvent(Event event) {
        char character;
        char key;
        boolean result = false;
        if (event.type == 1 && (this.accelerator & SWT.MODIFIER_MASK) == event.stateMask && (key = Character.toUpperCase((char)(this.accelerator & 0x100FFFF))) == (character = Character.toUpperCase(event.character))) {
            result = true;
        }
        return result;
    }

    private void updateDisplayFilter(int oldAccelerator, int newAccelerator) {
        if (oldAccelerator == 0 && newAccelerator != 0) {
            this.menuItem.display.addFilter(1, this);
        } else if (oldAccelerator != 0 && newAccelerator == 0) {
            this.menuItem.display.removeFilter(1, this);
        }
    }

    private void updateDisplayActiveKeys(int oldAccelerator, int newAccelerator) {
        this.updateDisplayActiveKeys("org.eclipse.rap.rwt.activeKeys", oldAccelerator, newAccelerator);
        this.updateDisplayActiveKeys("org.eclipse.rap.rwt.cancelKeys", oldAccelerator, newAccelerator);
    }

    private void updateDisplayActiveKeys(String keysType, int oldAccelerator, int newAccelerator) {
        String[] oldActiveKeys = (String[])this.menuItem.display.getData(keysType);
        if (oldActiveKeys == null) {
            oldActiveKeys = new String[]{};
        }
        ArrayList<String> activeKeys = new ArrayList<String>(Arrays.asList(oldActiveKeys));
        if (oldAccelerator != 0) {
            activeKeys.remove(AcceleratorBinding.acceleratorAsString(oldAccelerator));
        }
        if (newAccelerator != 0) {
            activeKeys.add(AcceleratorBinding.acceleratorAsString(newAccelerator));
        }
        this.menuItem.display.setData(keysType, activeKeys.toArray(new String[0]));
    }

    private static String acceleratorAsString(int accelerator) {
        String result = "";
        if ((accelerator & 0x10000) != 0) {
            result = String.valueOf(result) + "ALT+";
        }
        if ((accelerator & 0x40000) != 0) {
            result = String.valueOf(result) + "CTRL+";
        }
        if ((accelerator & 0x20000) != 0) {
            result = String.valueOf(result) + "SHIFT+";
        }
        char key = (char)(accelerator & 0x100FFFF);
        result = String.valueOf(result) + Character.toString(Character.toUpperCase(key));
        return result;
    }
}

