/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.json;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonNumber;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonString;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.json.ParseException;

class JsonParser {
    private final Reader reader;
    private final StringBuilder recorder;
    private int current;
    private int line;
    private int column;

    JsonParser(Reader reader) {
        this.reader = reader;
        this.recorder = new StringBuilder();
    }

    JsonValue parse() throws IOException {
        this.start();
        this.skipWhiteSpace();
        JsonValue result = this.readValue();
        this.skipWhiteSpace();
        if (!this.endOfText()) {
            throw this.error("Unexpected character");
        }
        return result;
    }

    private void start() throws IOException {
        this.line = 1;
        this.column = -1;
        this.read();
    }

    private JsonValue readValue() throws IOException {
        switch (this.current) {
            case 110: {
                return this.readNull();
            }
            case 116: {
                return this.readTrue();
            }
            case 102: {
                return this.readFalse();
            }
            case 34: {
                return this.readString();
            }
            case 91: {
                return this.readArray();
            }
            case 123: {
                return this.readObject();
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.readNumber();
            }
        }
        throw this.expected("value");
    }

    private JsonArray readArray() throws IOException {
        this.read();
        JsonArray array = new JsonArray();
        this.skipWhiteSpace();
        if (this.readChar(']')) {
            return array;
        }
        do {
            this.skipWhiteSpace();
            array.add(this.readValue());
            this.skipWhiteSpace();
        } while (this.readChar(','));
        if (!this.readChar(']')) {
            throw this.expected("',' or ']'");
        }
        return array;
    }

    private JsonObject readObject() throws IOException {
        this.read();
        JsonObject object = new JsonObject();
        this.skipWhiteSpace();
        if (this.readChar('}')) {
            return object;
        }
        do {
            this.skipWhiteSpace();
            String name = this.readName();
            this.skipWhiteSpace();
            if (!this.readChar(':')) {
                throw this.expected("':'");
            }
            this.skipWhiteSpace();
            object.add(name, this.readValue());
            this.skipWhiteSpace();
        } while (this.readChar(','));
        if (!this.readChar('}')) {
            throw this.expected("',' or '}'");
        }
        return object;
    }

    private JsonValue readNull() throws IOException {
        this.read();
        this.readRequiredChar('u');
        this.readRequiredChar('l');
        this.readRequiredChar('l');
        return JsonValue.NULL;
    }

    private JsonValue readTrue() throws IOException {
        this.read();
        this.readRequiredChar('r');
        this.readRequiredChar('u');
        this.readRequiredChar('e');
        return JsonValue.TRUE;
    }

    private JsonValue readFalse() throws IOException {
        this.read();
        this.readRequiredChar('a');
        this.readRequiredChar('l');
        this.readRequiredChar('s');
        this.readRequiredChar('e');
        return JsonValue.FALSE;
    }

    private void readRequiredChar(char ch) throws IOException {
        if (!this.readChar(ch)) {
            throw this.expected("'" + ch + "'");
        }
    }

    private JsonValue readString() throws IOException {
        this.read();
        this.recorder.setLength(0);
        while (this.current != 34) {
            if (this.current == 92) {
                this.readEscape();
                continue;
            }
            if (this.current < 32) {
                throw this.expected("valid string character");
            }
            this.recorder.append((char)this.current);
            this.read();
        }
        this.read();
        return new JsonString(this.recorder.toString());
    }

    private void readEscape() throws IOException {
        this.read();
        switch (this.current) {
            case 34: 
            case 47: 
            case 92: {
                this.recorder.append((char)this.current);
                break;
            }
            case 98: {
                this.recorder.append('\b');
                break;
            }
            case 102: {
                this.recorder.append('\f');
                break;
            }
            case 110: {
                this.recorder.append('\n');
                break;
            }
            case 114: {
                this.recorder.append('\r');
                break;
            }
            case 116: {
                this.recorder.append('\t');
                break;
            }
            case 117: {
                char[] hexChars = new char[4];
                int i = 0;
                while (i < 4) {
                    this.read();
                    if (!JsonParser.isHexDigit(this.current)) {
                        throw this.expected("hexadecimal digit");
                    }
                    hexChars[i] = (char)this.current;
                    ++i;
                }
                this.recorder.append((char)Integer.parseInt(String.valueOf(hexChars), 16));
                break;
            }
            default: {
                throw this.expected("valid escape sequence");
            }
        }
        this.read();
    }

    private JsonValue readNumber() throws IOException {
        this.recorder.setLength(0);
        this.readAndAppendChar('-');
        int firstDigit = this.current;
        if (!this.readAndAppendDigit()) {
            throw this.expected("digit");
        }
        if (firstDigit != 48) {
            while (this.readAndAppendDigit()) {
            }
        }
        this.readFraction();
        this.readExponent();
        return new JsonNumber(this.recorder.toString());
    }

    private boolean readFraction() throws IOException {
        if (!this.readAndAppendChar('.')) {
            return false;
        }
        if (!this.readAndAppendDigit()) {
            throw this.expected("digit");
        }
        while (this.readAndAppendDigit()) {
        }
        return true;
    }

    private boolean readExponent() throws IOException {
        if (!this.readAndAppendChar('e') && !this.readAndAppendChar('E')) {
            return false;
        }
        if (!this.readAndAppendChar('+')) {
            this.readAndAppendChar('-');
        }
        if (!this.readAndAppendDigit()) {
            throw this.expected("digit");
        }
        while (this.readAndAppendDigit()) {
        }
        return true;
    }

    private String readName() throws IOException {
        if (this.current != 34) {
            throw this.expected("name");
        }
        this.readString();
        return this.recorder.toString();
    }

    private boolean readAndAppendChar(char ch) throws IOException {
        if (this.current != ch) {
            return false;
        }
        this.recorder.append(ch);
        this.read();
        return true;
    }

    private boolean readChar(char ch) throws IOException {
        if (this.current != ch) {
            return false;
        }
        this.read();
        return true;
    }

    private boolean readAndAppendDigit() throws IOException {
        if (!JsonParser.isDigit(this.current)) {
            return false;
        }
        this.recorder.append((char)this.current);
        this.read();
        return true;
    }

    private void skipWhiteSpace() throws IOException {
        while (JsonParser.isWhiteSpace(this.current) && !this.endOfText()) {
            this.read();
        }
    }

    private void read() throws IOException {
        if (this.endOfText()) {
            throw this.error("Unexpected end of input");
        }
        if (this.current == 10) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        this.current = this.reader.read();
    }

    private boolean endOfText() {
        return this.current == -1;
    }

    private ParseException expected(String expected) {
        if (this.endOfText()) {
            return this.error("Unexpected end of input");
        }
        return this.error("Expected " + expected);
    }

    private ParseException error(String message) {
        return new ParseException(message, this.line, this.column);
    }

    private static boolean isWhiteSpace(int ch) {
        return ch == 32 || ch == 9 || ch == 10 || ch == 13;
    }

    private static boolean isDigit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    private static boolean isHexDigit(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }
}

