/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.application.EntryPointFactory;
import org.eclipse.rap.rwt.internal.lifecycle.DefaultEntryPointFactory;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryPointManager {
    private final Map<String, EntryPointRegistration> entryPoints = new HashMap<String, EntryPointRegistration>();

    public void register(String path, Class<? extends EntryPoint> type, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        this.checkValidPath(path);
        this.doRegister(path, new DefaultEntryPointFactory(type), properties);
    }

    public void register(String path, EntryPointFactory entryPointFactory, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        ParamCheck.notNull(entryPointFactory, "entryPointFactory");
        this.checkValidPath(path);
        this.doRegister(path, entryPointFactory, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAll() {
        Map<String, EntryPointRegistration> map = this.entryPoints;
        synchronized (map) {
            this.entryPoints.clear();
        }
    }

    public EntryPointRegistration getEntryPointRegistration(HttpServletRequest request) {
        EntryPointRegistration result = null;
        String path = request.getServletPath();
        if (path != null && path.length() > 0) {
            result = this.getRegistrationByPath(path);
        }
        if (result == null) {
            throw new IllegalArgumentException("Entry point not found: " + path);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPointRegistration getRegistrationByPath(String path) {
        Map<String, EntryPointRegistration> map = this.entryPoints;
        synchronized (map) {
            return this.entryPoints.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getServletPaths() {
        ArrayList<String> result;
        Map<String, EntryPointRegistration> map = this.entryPoints;
        synchronized (map) {
            result = new ArrayList<String>(this.entryPoints.keySet());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegister(String path, EntryPointFactory factory, Map<String, String> properties) {
        Map<String, EntryPointRegistration> map = this.entryPoints;
        synchronized (map) {
            this.checkPathAvailable(path);
            this.entryPoints.put(path, new EntryPointRegistration(factory, properties));
        }
    }

    private void checkValidPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must start with '/': " + path);
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Path must not end with '/': " + path);
        }
        if (path.length() > 0 && path.substring(1).contains("/")) {
            throw new IllegalArgumentException("Nested paths not yet supported: " + path);
        }
    }

    private void checkPathAvailable(String path) {
        if (this.entryPoints.containsKey(path)) {
            throw new IllegalArgumentException("Entry point already registered for path " + path);
        }
    }
}

