/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.WebClient;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rap.rwt.internal.lifecycle.RequestCounter;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.service.StartupJson;
import org.eclipse.rap.rwt.internal.service.StartupPage;
import org.eclipse.rap.rwt.internal.service.UISessionBuilder;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.service.UrlParameters;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.UISession;

public class LifeCycleServiceHandler
implements ServiceHandler {
    private static final String PROP_ERROR = "error";
    private static final String PROP_REQUEST_COUNTER = "requestCounter";
    private static final String ATTR_LAST_PROTOCOL_MESSAGE = String.valueOf(LifeCycleServiceHandler.class.getName()) + "#lastProtocolMessage";
    private static final String ATTR_SESSION_STARTED = String.valueOf(LifeCycleServiceHandler.class.getName()) + "#isSessionStarted";
    private final LifeCycleFactory lifeCycleFactory;
    private final StartupPage startupPage;

    public LifeCycleServiceHandler(LifeCycleFactory lifeCycleFactory, StartupPage startupPage) {
        this.lifeCycleFactory = lifeCycleFactory;
        this.startupPage = startupPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        Object object = uiSession.getRequestLock();
        synchronized (object) {
            this.synchronizedService(request, response);
        }
    }

    void synchronizedService(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("POST".equals(request.getMethod())) {
            try {
                this.handlePostRequest(request, response);
            }
            finally {
                if (!LifeCycleServiceHandler.isSessionShutdown()) {
                    LifeCycleServiceHandler.markSessionStarted();
                }
            }
        }
        try {
            this.handleGetRequest((ServletRequest)request, response);
        }
        finally {
            LifeCycleServiceHandler.shutdownUISession();
        }
    }

    private void handleGetRequest(ServletRequest request, HttpServletResponse response) throws IOException {
        if (RWT.getClient() instanceof WebClient) {
            this.startupPage.send(response);
        } else {
            StartupJson.send(response);
        }
    }

    private void handlePostRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LifeCycleServiceHandler.setJsonResponseHeaders((ServletResponse)response);
        if (!LifeCycleServiceHandler.isContentTypeValid((ServletRequest)request)) {
            LifeCycleServiceHandler.writeInvalidContentType(response);
        } else if (LifeCycleServiceHandler.isSessionShutdown()) {
            LifeCycleServiceHandler.shutdownUISession();
        } else if (LifeCycleServiceHandler.isSessionTimeout()) {
            LifeCycleServiceHandler.writeSessionTimeoutError(response);
        } else if (!LifeCycleServiceHandler.isRequestCounterValid()) {
            if (LifeCycleServiceHandler.isDuplicateRequest()) {
                LifeCycleServiceHandler.writeBufferedResponse(response);
            } else {
                LifeCycleServiceHandler.writeInvalidRequestCounterError(response);
            }
        } else {
            if (LifeCycleServiceHandler.isSessionRestart()) {
                LifeCycleServiceHandler.reinitializeUISession(request);
                LifeCycleServiceHandler.reinitializeServiceStore();
            }
            UrlParameters.merge();
            this.runLifeCycle();
            LifeCycleServiceHandler.writeProtocolMessage((ServletResponse)response);
        }
    }

    private void runLifeCycle() throws IOException {
        if (LifeCycleServiceHandler.hasInitializeParameter()) {
            RemoteObjectLifeCycleAdapter.readData();
        }
        LifeCycle lifeCycle = this.lifeCycleFactory.getLifeCycle();
        lifeCycle.execute();
    }

    private static boolean isRequestCounterValid() {
        return LifeCycleServiceHandler.hasInitializeParameter() || LifeCycleServiceHandler.hasValidRequestCounter();
    }

    static boolean hasValidRequestCounter() {
        int currentRequestId = RequestCounter.getInstance().currentRequestId();
        JsonValue sentRequestId = ProtocolUtil.getClientMessage().getHeader(PROP_REQUEST_COUNTER);
        if (sentRequestId == null) {
            return currentRequestId == 0;
        }
        return currentRequestId == sentRequestId.asInt();
    }

    private static boolean isDuplicateRequest() {
        int currentRequestId = RequestCounter.getInstance().currentRequestId();
        JsonValue sentRequestId = ProtocolUtil.getClientMessage().getHeader(PROP_REQUEST_COUNTER);
        return sentRequestId != null && sentRequestId.asInt() == currentRequestId - 1;
    }

    private static boolean isContentTypeValid(ServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.startsWith("application/json");
    }

    private static void shutdownUISession() {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        uiSession.shutdown();
    }

    private static void writeInvalidRequestCounterError(HttpServletResponse response) throws IOException {
        String errorType = "invalid request counter";
        LifeCycleServiceHandler.writeError(response, 412, errorType);
    }

    private static void writeSessionTimeoutError(HttpServletResponse response) throws IOException {
        String errorType = "session timeout";
        LifeCycleServiceHandler.writeError(response, 403, errorType);
    }

    private static void writeInvalidContentType(HttpServletResponse response) throws IOException {
        String errorType = "invalid content type";
        LifeCycleServiceHandler.writeError(response, 400, errorType);
    }

    private static void writeError(HttpServletResponse response, int statusCode, String errorType) throws IOException {
        response.setStatus(statusCode);
        ProtocolMessageWriter writer = new ProtocolMessageWriter();
        writer.appendHead(PROP_ERROR, JsonValue.valueOf(errorType));
        writer.createMessage().writeTo(response.getWriter());
    }

    private static void reinitializeUISession(HttpServletRequest request) {
        ServiceContext serviceContext = ContextProvider.getContext();
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        uiSession.shutdown();
        UISessionBuilder builder = new UISessionBuilder(serviceContext);
        uiSession = builder.buildUISession();
        serviceContext.setUISession(uiSession);
    }

    private static void reinitializeServiceStore() {
        ClientMessage clientMessage = ProtocolUtil.getClientMessage();
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.clear();
        ProtocolUtil.setClientMessage(clientMessage);
    }

    private static boolean isSessionRestart() {
        return LifeCycleServiceHandler.isSessionStarted() && LifeCycleServiceHandler.hasInitializeParameter();
    }

    private static boolean isSessionTimeout() {
        return !LifeCycleServiceHandler.isSessionStarted() && !LifeCycleServiceHandler.hasInitializeParameter();
    }

    static void markSessionStarted() {
        UISession uiSession = ContextProvider.getUISession();
        uiSession.setAttribute(ATTR_SESSION_STARTED, Boolean.TRUE);
    }

    private static boolean isSessionStarted() {
        UISession uiSession = ContextProvider.getUISession();
        return Boolean.TRUE.equals(uiSession.getAttribute(ATTR_SESSION_STARTED));
    }

    private static boolean isSessionShutdown() {
        JsonValue shutdownHeader = ProtocolUtil.getClientMessage().getHeader("rwt_shutdown");
        return JsonValue.TRUE.equals(shutdownHeader);
    }

    private static boolean hasInitializeParameter() {
        JsonValue initializeHeader = ProtocolUtil.getClientMessage().getHeader("rwt_initialize");
        return JsonValue.TRUE.equals(initializeHeader);
    }

    private static void setJsonResponseHeaders(ServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
    }

    private static void writeProtocolMessage(ServletResponse response) throws IOException {
        JsonObject message = ContextProvider.getProtocolWriter().createMessage();
        LifeCycleServiceHandler.bufferProtocolMessage(message);
        message.writeTo(response.getWriter());
    }

    private static void writeBufferedResponse(HttpServletResponse response) throws IOException {
        LifeCycleServiceHandler.getBufferedMessage().writeTo(response.getWriter());
    }

    private static void bufferProtocolMessage(JsonObject message) {
        UISession uiSession = ContextProvider.getUISession();
        if (uiSession != null) {
            uiSession.setAttribute(ATTR_LAST_PROTOCOL_MESSAGE, message);
        }
    }

    private static JsonObject getBufferedMessage() {
        return (JsonObject)ContextProvider.getUISession().getAttribute(ATTR_LAST_PROTOCOL_MESSAGE);
    }
}

